# -*- encoding=utf8 -*-
__author__ = "xujin"

from airtest.core.api import *
from airtest.core.device import Device

import random

auto_setup(__file__)


from poco.drivers.android.uiautomation import AndroidUiautomationPoco
poco = AndroidUiautomationPoco(use_airtest_input=True, screenshot_each_action=False)

def swipe_up():
    # 滑动屏幕
    x = random.uniform(0.3, 0.6)
    y_start = random.uniform(0.6, 0.8)
    y_end = random.uniform(0.2, 0.3)
    duration_seconds = random.uniform(0.3, 0.5)
    poco.swipe([x, y_start], [x, y_end], duration = duration_seconds)

def like():
    # 随机点赞，提升账号活跃权重
    rand_val = random.randint(0, 9)
    log('随机点赞或者收藏，随机数：' + str(rand_val))
    if rand_val == 0 and exists(Template(r"tpl1741830566835.png", record_pos=(0.421, 0.054), resolution=(720, 1600))):
        click(Template(r"tpl1741830566835.png", record_pos=(0.421, 0.054), resolution=(720, 1600)))
        log('点赞视频')
    elif rand_val == 9 and exists(Template(r"tpl1741830791079.png", record_pos=(0.419, 0.388), resolution=(720, 1600))):
        click(Template(r"tpl1741830791079.png", record_pos=(0.419, 0.388), resolution=(720, 1600)))
        log('收藏视频')



def rand_click(position, start_pos, target_pos, target_size):
    """ 
    随机点击，避免被检测
    :position 实际开始的位置
    :start_pos 开始区域的位置，由poco选取
    :target_pos 目标区域的位置，由poco选取，与start_pos配合，计算偏移量
    :target_size 目标区域的大小，用于随机计算偏移量
    """
    offset_x = target_pos[0] - start_pos[0]
    offset_y = target_pos[1] - start_pos[1]
    rand = random.randint(0, 1)
    if rand == 0:
        x = position[0] + offset_x + random.uniform(0, target_size[0] * 0.3)
        y = position[1] + offset_y - random.uniform(0, target_size[1] * 0.3)
    else:
        x = position[0] + offset_x - random.uniform(0, target_size[0] * 0.3)
        y = position[1] + offset_y + random.uniform(0, target_size[1] * 0.3)
    poco.click([x, y])
        
def watch_video():
    # 刷视频
    fail_times = 0
    while True:
        sleep_millis = random.randint(30, 75)
        log('随机sleep' + str(sleep_millis) + '秒')
        sleep(sleep_millis)
        if exists(Template(r"tpl1741831232143.png", record_pos=(0.419, 0.325), resolution=(720, 1600))):
            like()
            sleep(1)
            swipe_up()
            # 重置失败次数
            fail_times = 0
        else:
            live = poco(textMatches=r'^.*直播.*$')
            more = poco(textMatches=r'更多直播')
            if more.exists():
                more_position = more.get_position()
                rand_click(more_position, more_position, [0.9416666666666667, 0.0575], [0.0625, 0.028125])
                # 重置失败次数
                fail_times = 0
                sleep(3)
                swipe_up()
            elif live.exists():
                log('跳过直播')
                swipe_up()
                # 重置失败次数
                fail_times = 0
            else:
                if fail_times >= 1:
                    swipe_up()
                    fail_times = 0
                else:
                    fail_times = fail_times + 1
                log('没找到特征值，不做任何操作')

if __name__ == '__main__':
    mode = os.getenv("AIRTEST_MODE", "default")
    log("当前模式: " + mode)
    
    # 查找 --device 参数的位置
    if "--device" in sys.argv:
        device_index = sys.argv.index("--device")
        device_id = sys.argv[device_index + 1]
        print("原始设备参数:", device_id)
    else:
        print("未传递 --device 参数")
        
        
    # 获取当前设备连接对象
    device_obj = G.DEVICE

    # 提取设备ID（字符串形式）
    if isinstance(device_obj, Device):
        device_id = device_obj.uuid
        print("当前设备ID:", device_id)
    else:
        print("未获取到有效设备连接")    
        
    print("serialno: ", device().serialno) 

    # 默认刷视频
    watch_video()
#     for i in range(0, 10):
#         swipe_up()
#         sleep(3)

