# -*- encoding=utf8 -*-
__author__ = "sunrg"

from ast import Raise, Set
from operator import index
from pydoc import classname, describe
from socket import timeout
from airtest.core.api import *
from airtest.core.android.android import *
import time
import random
import json
import re
import base64
import requests
from datetime import date, datetime, timedelta
from airtest.aircv import *
import cv2
import threading
import numpy as np
import logging
import websocket
import functools
import uiautomator2 as u2

session = requests.Session()
# 配置日志级别
logger = logging.getLogger("airtest")
logger.setLevel(logging.INFO)

auto_setup(__file__)


host = "127.0.0.1:8080"
# host = "192.168.0.106:8080"
remote_host = "https://jisu.p1024.top/jisu-server"

d = u2.connect(device().serialno)
print(f"设备信息为：{d.info}")
d.implicitly_wait(10.0)

OCRHost = "https://wephone.ischeng.com/ocr"
DATA_FILE = "douyinlite.json"
SUMMARY_FILE = "douyinlite_summary.json"
dev = device()
# dev.touch_method = "MINITOUCH"
SCRIPT_NAME = "douyinLite.air"
PKG = "com.ss.android.ugc.aweme.lite"

ws = None
today = str(date.today())
token = ""
app_page_state = "home"  # task
SOURCE_MAP = {
    "search": "搜索",
    "people.search": "大家都在搜",
    "active": "推荐页",
    "box": "大宝",
    "pig": "养猪",
    "ad": "AD广",
    "sign": "签到",
    "eat": "吃饭",
    "order": "预约",
    "interval": "小活跃",
}
config = {
    # 单次执行时长（分）
    "basic.cycle.time": 180,
    # 本次运行任务 recommend：推荐  hot：热点 search:搜索  box：大宝 pig：养猪  sign：签到  order：预约  ad：ad广
    # "basic.cycle.tasks": ["pig", "box", "sign", "order"],
    "basic.cycle.tasks": ["active", "hot", "box", "pig", "sign", "order"],
    # 重新拉起应用间隔（秒）
    "basic.kill.sleep": 20,
    # 首次打开脚本是否签到
    # "basic.sign": True,
    # 直播间小宝箱是否启用
    "basic.live.small.box.flag": True,
    # 每次启动脚本是否执行活跃
    "basic.active.reset.flag": False,
    # 一轮任务金币均值最低，低于做大活跃
    "basic.coin.low": 400,
    # 当日金币目标
    "basic.coin.target": 50000,
    # 直播间点赞次数
    "config.live.like.top.count": 10,
    # 一轮金币任务间歇是否杀掉当前脚本
    "basic.gold.task.end.kill": True,
    # 金币广告做活跃权重
    "basic.gold.active.weight": 5,
    # "basic.live.likes.count.active": 10,
    # # 宝箱时直播间点赞次数
    # "basic.live.likes.count.box": 10,
    # # ad广时直播间点赞次数
    # "basic.live.likes.count.ad": 10,
    # # 小猪时直播间点赞次数
    # "basic.live.likes.count.pig": 10,
    # 直播间单次评论次数
    "config.live.comment.count": 1,
    # # 活跃时直播间评论次数
    # "basic.live.comment.count.active": 1,
    # # 宝箱时直播间评论次数
    # "basic.live.comment.count.box": 1,
    # # ad广时直播间评论次数
    # "basic.live.comment.count.ad": 1,
    # # 养猪时直播间评论次数
    # "basic.live.comment.count.pig": 1,
    # 活跃时视频点赞权重
    "config.video.like.weight": 7,
    # 活跃时视频收藏权重
    "config.video.collect.weight": 7,
    # 活跃时视频关注权重
    "config.video.focus.weight": 7,
    # 活跃时视频评论权重
    "config.video.comment.weight": 7,
    # 活跃时视频推荐权重
    "config.video.recommend.weight": 7,
    # 活跃顺序
    "active.plan.order": "123",
    # 活跃是否看推荐页
    "active.recommend.enable": True,
    # 活跃看推荐页视频数量
    "active.recommend.mode.value": 10,
    # 活跃看推荐模式 count 数量 time 时长
    "active.recommend.mode": "count",
    # 活跃看推荐页的直播时长 （分）
    "active.recommend.live.minutes.min": 3,
    "active.recommend.live.minutes.max": 5,
    # 活跃看推荐页的视频停留时长 （秒）
    "active.recommend.video.seconds.min": 30,
    "active.recommend.video.seconds.max": 60,
    # 活跃是否看热点 （热点抖音放推荐后面）
    "active.hot.enable": True,
    # 活跃看热点个数
    "active.hot.mode.value": 8,
    # 活跃看热点模式 count 个数  time 时长
    "active.hot.mode": "count",
    # 活跃看热点视频时长（秒）
    "active.hot.video.seconds.min": 30,
    "active.hot.video.seconds.max": 90,
    # 活跃 大家都在搜是否启用
    "active.recommend.people.search.enable": True,
    # 活跃 大家都在搜 执行次数
    "active.recommend.people.search.count": 5,
    # 活跃 大家都在搜 直播停留时长（分）
    "active.recommend.people.search.live.minutes.min": 3,
    "active.recommend.people.search.live.minutes.max": 5,
    # 活跃 大家都在搜 视频停留时长（秒）
    "active.recommend.people.search.video.seconds.min": 20,
    "active.recommend.people.search.video.seconds.max": 50,
    # 活跃 搜索是否启用
    "active.key.search.enable": True,
    # 活跃 搜索标签相关内容
    "active.key.search.tags": [
        {
            "id": 1747108113153,
            "keywords": "男⼠T恤",  # 搜索关键字
            "match": "T恤",  # 搜索匹配关键字
            "count": 2,  # 搜索次数
            "live": [3, 5],  # 搜索直播停留时长
            "video": [30, 60],  # 搜索视频停留时长
            "index": 0,
        },
        {
            "id": 1747108113163,
            "keywords": "名扬传世",  # 搜索关键字
            "match": "名扬,传世,传奇",  # 搜索匹配关键字
            "count": 2,  # 搜索次数
            "live": [3, 5],  # 搜索直播停留时长
            "video": [30, 60],  # 搜索视频停留时长
            "index": 1,
        },
    ],
    # 开宝箱 打开任务页后等候时长 （秒）
    "coin.box.wait.seconds": 10,
    # 宝箱是否看视频详情
    "coin.box.video.detail.enable": True,
    # 宝箱看详情次数
    "coin.box.video.detail.count": 3,
    # 宝箱视频详情打开后停留时长（秒）
    "coin.box.video.detail.seconds": 10,
    # 宝箱是否进直播间
    "coin.box.live.enable": True,
    # 宝箱直播间停留时长 （秒）
    "coin.box.live.seconds": 60,
    # 宝箱是否跳转其他应用
    "coin.box.other.app.enable": True,
    # 宝箱跳转其他应用停留时长（秒）
    "coin.box.other.app.seconds": 30,
    # 养猪是否根据搜索条件匹配广告
    "coin.pig.match.with.tags": True,
    # 养猪是否等金币结束就返回列表
    "coin.pig.on.coin.stop.back": True,
    # 养猪是否查看视频详情
    "coin.pig.video.detail.enable": True,
    # 养猪查看视频详情次数
    "coin.pig.video.detail.count": 3,
    # 养猪视频详情停留时长（秒）
    "coin.pig.video.detail.seconds": 10,
    # 养猪是否进直播间
    "coin.pig.live.enable": True,
    # 养猪直播间停留时长（秒）
    "coin.pig.live.seconds": 60,
    # 养猪是否打开其他应用
    "coin.pig.other.app.enable": True,
    # 养猪跳转其他应用停留时长（秒）
    "coin.pig.other.app.seconds": 30,
    # ad广是否查看视频详情
    "coin.ad.video.detail.enable": True,
    # ad广查看视频详情次数
    "coin.ad.video.detail.count": 3,
    # ad广视频详情停留时长（秒）
    "coin.ad.video.detail.seconds": 10,
    # ad广是否进直播间
    "coin.ad.live.enable": True,
    # ad广直播间停留时长（秒）
    "coin.ad.live.seconds": 60,
    # ad广是否打开其他应用
    "coin.ad.other.app.enable": True,
    # ad广打开其他应用停留时长（秒）
    "coin.ad.other.app.seconds": 30,
    "cycle.box.max": 5,
    "cycle.pig.max": 6,
    "cycle.ad.max": 5,
}

number_pattern = r"^\d+$"
# 本次运行汇总
cycle_summary = {}

common_comments = [
    "[赞][赞][赞][赞]",
    "[比心][比心][比心][比心][比心][比心]",
    "[666][666][666]",
    "[色][色][色]",
    "[爱心][爱心][爱心][爱心][爱心]",
    "[鼓掌][鼓掌][鼓掌][鼓掌][鼓掌][鼓掌]",
]
ad_time = 0
ad_time_interval = 5
box_time = 0
box_time_interval = 10
pig_time = 0
pig_time_interval = 20
start_time = 0

# 单轮广告详情
cycle_ad_coin = []
cycle_ad_name = []
cycle_total_coin = 0
# 当一轮金币数在3千到5千时，广告数大于等于3个的话，做小活跃时时长稍微增加
cycle_interval_add = False

# 当前在执行的金币任务
current_gold_task = ""
# 爬楼时单次金币任务金额小于配置的金额了
cycle_low_coin = False
# 小猪是否暂停了
is_suspended = False
# 一轮金币任务是否已完成
cycle_task_done = False
# 是否检测在应用中
check_in_app = True

# ========== 退出事件 ==========
exit_event = threading.Event()

jingcai_index = 0
jingcai_random_list = []

search_index = 0
search_random_list = []

# 看广告时是否已进过直播间
ad_live_entered = False
live_send_ticket_count = 0

height = d.window_size()[1]
width = d.window_size()[0]


# =========基础能力========
def my_print(t):
    print(f"抖音极速版--{d.serial}--{time_format()}--{t}")


def ensure_app_active(func):
    """装饰器：确保目标应用在前台运行，否则拉起并重试最多3次"""

    @functools.wraps(func)
    def wrapper(*args, **kwargs):
        global check_in_app
        if not check_in_app:
            return func(*args, **kwargs)
        for count in range(3):
            try:
                top_info = dev.get_top_activity()
                if top_info[0] == PKG:
                    # my_print("functools-应用已在前台")
                    return func(*args, **kwargs)
                my_print(f"functools-应用未运行，尝试拉起（{count+1}/3）")
                start_app(PKG)
                sleep(10)

                top_info1 = dev.get_top_activity()
                my_print(f"functools-重新检测应用为：{top_info1[0]},预期为:{PKG}")
                if top_info1[0] == PKG:
                    return func(*args, **kwargs)
                else:
                    my_print("functools-未能拉起应用")
            except Exception as e:
                my_print(f"异常:{e}")
        my_print(f"functools-一直未能拉起抖音，结束脚本")
        end_script({"reason": "一直未能拉起抖音，结束脚本"})

    return wrapper


def sys_back():
    my_print("执行系统返回")
    # keyevent("BACK")
    d.press("back")


def get_previous_date(days=1):
    """获取指定天数前的日期（默认前1天）"""
    return (datetime.now() - timedelta(days=days)).strftime("%Y-%m-%d")


def images_are_similar(img1, img2, threshold=100):
    # 将两张图片转换为灰度图
    img1_gray = cv2.cvtColor(np.array(img1), cv2.COLOR_BGR2GRAY)
    img2_gray = cv2.cvtColor(np.array(img2), cv2.COLOR_BGR2GRAY)

    # 计算均方误差 MSE
    err = np.sum((img1_gray.astype("float") - img2_gray.astype("float")) ** 2)
    err /= float(img1_gray.shape[0] * img1_gray.shape[1])

    return err < threshold


def time_format(timestamp=None):
    """获取格式化日期"""
    if timestamp:
        local_time = time.localtime(timestamp)  # 返回结构化时间
        formatted_time = time.strftime("%Y-%m-%d %H:%M:%S", local_time)
        return formatted_time
    return datetime.now().strftime("%Y-%m-%d %H:%M:%S")


def screen_checker():
    """屏幕对比，是否一致（卡住了？）"""
    last_snapshot = None
    same_count = 0
    global check_in_app

    CHECK_INTERVAL = 90
    MAX_SAME_COUNT = 2
    while True:

        # top_info = dev.get_top_activity()
        # if check_in_app and not top_info[0] == PKG:
        #     my_print("检测到当前打开的应用不是抖极，结束脚本")
        #     snapshot(msg=f"非抖极结束脚本-{time.time()}")
        #     sleep(2)
        #     end_script({"reason": "检测到退出抖极，停止脚本"})
        #     break
        screen = G.DEVICE.snapshot()
        current_screen = aircv.crop_image(screen, (200, 600, width - 200, height - 300))
        if last_snapshot is not None:
            if current_screen.shape != last_snapshot.shape:
                my_print(
                    f"当前截图尺寸 {current_screen.shape} 与历史截图尺寸 {last_snapshot.shape} 不一致，跳过比较"
                )
                last_snapshot = current_screen  # 可选：更新历史截图为新尺寸
                same_count = 0  # 重置计数避免误判
            else:
                if images_are_similar(current_screen, last_snapshot):
                    same_count += 1
                    if same_count >= MAX_SAME_COUNT:
                        d.screenshot(f"screen-holdon-{int(time.time())}.jpg")
                        my_print("检测到界面连续2次未变化，退出应用")
                        snapshot(msg=f"界面未变化-{time.time()}")
                        sleep(2)
                        end_script({"reason": "检测到界面连续2次未变化，退出脚本"})
                        break
                    else:
                        my_print("检测到界面一致")
                        # 尝试返回一下关闭可能弹窗
                        sys_back()
                else:
                    same_count = 0
                    last_snapshot = current_screen
        else:
            same_count = 0
            last_snapshot = current_screen

        time.sleep(CHECK_INTERVAL)


# DATA_FILE if is_data else SUMMARY_FILE
def load_data(path):
    """加载 JSON 文件数据，若文件不存在则返回空字典"""
    try:
        with open(path, "r", encoding="utf-8") as f:
            return json.load(f)
    except (FileNotFoundError, json.JSONDecodeError):
        return {}


# is_data=True
def save_data(data, path=DATA_FILE):
    """将数据保存到 JSON 文件"""
    with open(path, "w", encoding="utf-8") as f:
        json.dump(data, f, indent=2, ensure_ascii=False)


# is_data=True
def save_data_with_key(key, data, path=DATA_FILE, params={}):
    """根据key更新json数据，cumulation：在原有基础上累加"""
    ori = load_data(path)
    date_entry = ori.setdefault(today, {})
    device_entry = date_entry.setdefault(d.serial, {})
    cumulation = params.get("cumulation", False)
    if cumulation:
        if not isinstance(data, (int, float)):
            raise TypeError(
                f"参数类型错误！期望类型: int float, 实际类型: {type(data)}"
            )
        ori_num = device_entry.get(key, 0)
        device_entry[key] = ori_num + data
    else:
        device_entry[key] = data
    save_data(ori, path)


# is_data=True
def save_data_with_obj(obj, path=DATA_FILE):
    """批量更新json数据"""
    ori = load_data(path)
    date_entry = ori.setdefault(today, {})
    device_entry = date_entry.setdefault(d.serial, {})
    device_entry = {**device_entry, **obj}
    save_data(ori, path)


def record_operation(operation, start_time: int = 0, end_time: int = 0):
    """记录设备执行了某个操作"""
    save_data_with_key(operation, True)
    if end_time == 0:
        end_time = int(time.time())
    data = {"startTime": start_time, "endTime": end_time}
    task_type = None
    if operation == "recommend_executed":
        task_type = "active"
    elif operation == "signed":
        task_type = "sign_in"
    elif operation == "box_executed":
        task_type = "box"
    elif operation == "pig_executed":
        task_type = "pig"
    elif operation == "search_executed":
        task_type = "search"
    if task_type:
        data["taskType"] = task_type
        ws_report(data, reportType="task_end")


def unset_operation(operation: str, value=None):
    """
    重置操作
    """
    save_data_with_key(operation, value)


# 秒转换为时分秒
def convert_seconds(seconds):
    """将秒转换为 时 分 秒"""
    seconds = abs(int(seconds))
    hours, remaining = divmod(seconds, 3600)
    minutes, seconds = divmod(remaining, 60)
    return f"{hours}小时{minutes}分{seconds}秒"


def read_data(key=None, default=None, path=DATA_FILE):
    """读取设备相关缓存"""
    data = load_data(path)
    ori = data.get(today, {}).get(d.serial, {})
    if key:
        return ori.get(key, default)
    return ori


def check_operation(operation):
    """检查设备是否在某天执行了某个操作"""
    data = load_data(DATA_FILE)
    return data.get(today, {}).get(d.serial, {}).get(operation, False)


def clear_before_log():
    """删除昨天之前的json缓存"""
    my_print("删除之前日志")
    log_data = load_data(SUMMARY_FILE)
    data = load_data(DATA_FILE)

    t_d = data.get(today, {})
    y_d = data.get(get_previous_date(), {})

    t_d_l = log_data.get(today, {})
    y_d_l = log_data.get(get_previous_date(), {})

    save_data({today: t_d, get_previous_date(): y_d})
    save_data({today: t_d_l, get_previous_date(): y_d_l}, SUMMARY_FILE)


def trans_abs_pos(pos):
    """将相对坐标转为绝对坐标"""
    return (pos[0] * width, pos[1] * height)


def random_pos(pos, x_range=0, y_range=0, tag=""):
    """获取范围内的随机坐标"""
    # 处理范围参数
    x_min = pos[0] + (x_range[0] if isinstance(x_range, tuple) else -x_range)
    x_max = pos[0] + (x_range[1] if isinstance(x_range, tuple) else x_range)
    y_min = pos[1] + (y_range[0] if isinstance(y_range, tuple) else -y_range)
    y_max = pos[1] + (y_range[1] if isinstance(y_range, tuple) else y_range)

    # 生成随机坐标
    rand_x = random.randint(int(x_min), int(x_max))
    rand_y = random.randint(int(y_min), int(y_max))
    if tag != "直播间点赞":
        my_print(f"-{tag}-随机坐标为：{(rand_x, rand_y)}")
    return (rand_x, rand_y)


@ensure_app_active
def random_touch(pos, x_range, y_range, times=1, tag=""):
    """点击范围内的随机坐标"""
    npos = random_pos(pos, x_range, y_range, tag)
    # touch(npos, times=times)
    d.click(npos[0], npos[1])


def random_touch_u2(node, times=1, tag=""):
    node.click(offset=(random.uniform(0.2, 0.8), random.uniform(0.2, 0.8)))
    my_print(tag)


def check_weight(n: int = 0):
    """检测权重"""
    if not n:
        n = random.randint(0, 10)
    if not 0 <= n <= 10:
        raise ValueError("输入必须为0-10的整数")

    # 计算概率阈值（n*10）
    probability_threshold = n * 10

    # 生成1-100的随机整数
    rand_value = random.randint(1, 100)

    # 命中判断
    return rand_value <= probability_threshold


def back_to_home():
    global app_page_state
    """检测是否回到首页"""
    if not check_home_page_status():
        my_print("不在首页，准备返回")
        sys_back()
        back_to_home()
    else:
        app_page_state = "home"


def check_home_page_status():
    """检测是否回到首页"""
    pos = exists(
        Template(
            r"tpl1744075956673.png",
            record_pos=(-0.001, 1.003),
            resolution=(1080, 2340),
        )
    )
    if pos:
        return True
    return False


def refresh_home_recommend():
    """刷新推荐页"""
    home_btn = d(
        text="首页", description="首页，按钮", className="android.widget.TextView"
    )
    if home_btn.exists:
        random_touch_u2(home_btn)
        sleep(0.01)
        random_touch_u2(home_btn)


def ocr_screen(region=None):
    """截屏，返回ocr识别结果，可局部截屏"""
    screen = G.DEVICE.snapshot()
    if region:
        screen = aircv.crop_image(screen, region)
    _, buffer = cv2.imencode(".jpeg", screen)
    # screen.save(buffer, format="JPEG", quality=85)  # 压缩率控制
    base64_str = base64.b64encode(buffer).decode("utf-8")
    headers = {"Content-Type": "application/json"}
    payload = {
        "images": [base64_str],
    }

    try:
        response = requests.post(
            OCRHost + "/predict/ch_pp-ocrv3", json=payload, headers=headers, timeout=10
        )
        response.raise_for_status()  # 自动处理HTTP错误码
        results = response.json()["results"]
        if len(results):
            return results[0]["data"]
        return []
    except requests.exceptions.RequestException as e:
        my_print(f"ocr_error:{str(e)}")
        return []


def get_comment_by_time():
    """根据时间获取评论"""
    good = ""
    current_hour = int(datetime.now().hour)
    if current_hour >= 6 and current_hour < 9:
        good = "早上好"

    elif current_hour >= 9 and current_hour < 12:
        good = "上午好"

    elif current_hour >= 12 and current_hour < 14:
        good = "中午好"

    elif current_hour >= 14 and current_hour < 19:
        good = "下午好"

    else:
        good = "晚上好"

    list = [good, "主播好", f"主播{good}"]
    rand = random.randint(0, len(list) - 1)
    return list[rand]


# ============金币任务相关============


# 查找金币活动页入口
def find_task_entry():
    global start_time
    global app_page_state
    diff = int(time.time()) - start_time
    t = config.get("basic.cycle.time", 180)
    if diff > random.randint(t - 10, t + 10) * 60:
        my_print("超时结束脚本")
        end_script({"reason": "到时间退出"})
        return

    my_print(f"find_task_entry--当前在{app_page_state}页")

    if app_page_state == "task":
        return True
    max_retries = 5
    for count in range(max_retries + 1):
        pos = exists(
            Template(
                r"tpl1744075956673.png",
                record_pos=(-0.001, 1.003),
                resolution=(1080, 2340),
            )
        )
        if pos:
            random_touch(pos, 20, 20, tag="点金币活动入口")
            sleep(5)
            app_page_state = "task"

            signed = check_operation("signed")
            pre_ordered = check_operation("pre_ordered")
            if not signed or not pre_ordered:
                sleep(10)
                my_print("开始日常任务")
                check_task_alert()
                start_daily_task()
            return True

        if count == max_retries:
            my_print("未找到任务入口")
            ws_report({"message": f"未找到金币入口，先做其他任务"})
            return False
        sleep(2)
    return False


# def start_gold_task():
#     global cycle_low_coin
#     global box_time
#     global app_page_state
#     tasks = config.get("basic.cycle.tasks", [])
#     """有活跃任务，则标记已做完活跃"""
#     if "active" in tasks:
#         save_data_with_key("total.tasks.active.flag", True, SUMMARY_FILE)

#     """没有金币任务回去重做活跃"""
#     if "box" not in tasks and "pig" not in tasks and "ad" not in tasks:
#         my_print("没配置金币任务，返回做活跃")
#         save_data_with_obj(
#             {
#                 "watched_recommend_count": 0,
#                 "recommend_executed": False,
#                 "search_execute_count": 0,
#                 "search_executed": False,
#                 "searched_count": 0,
#                 "hot_executed": False,
#                 "watched_hot_count": 0,
#             }
#         )
#         ws_report({"message": f"未配置金币任务,重新做大活跃一轮"})

#         start_active_task()
#         return
#     pos = exists(
#         Template(
#             r"tpl1744075956673.png", record_pos=(-0.001, 1.003), resolution=(1080, 2340)
#         )
#     )
#     if pos:
#         random_touch(pos, 20, 20, tag="点金币活动入口")
#         sleep(5)
#         app_page_state = 'task'
#         check_task_alert()
#     else:
#         my_print("未找到任务入口")
#         box_time = int(time.time())
#         ws_report({"message": f"未找到金币入口，先做间歇活跃再尝试找任务入口"})
#         start_interval_task()
#         return

#     global cycle_task_done
#     my_print("开始金币任务")
#     cycle_task_done = False
#     sleep(5)
#     find_daily()
#     signed = check_operation("signed")
#     pre_ordered = check_operation("pre_ordered")
#     # t = ""
#     # eated = False
#     # current_hour = int(datetime.now().hour)
#     # if current_hour >= 6 and current_hour < 9:
#     #     my_print("早饭")
#     #     t = "breakfast"
#     #     eated = check_operation( "breakfast")

#     # elif current_hour >= 11 and current_hour < 14:
#     #     my_print("早饭")
#     #     t = "launch"
#     #     eated = check_operation( "launch")

#     # elif current_hour >= 17 and current_hour < 20:
#     #     my_print("晚饭")
#     #     t = "dinner"
#     #     eated = check_operation( "dinner")

#     # elif current_hour >= 21 and current_hour < 24:
#     #     my_print("夜宵")
#     #     t = "nightsnack"
#     #     eated = check_operation( "nightsnack")
#     # (t != "" and not eated) or
#     if not signed or not pre_ordered:
#         my_print("开始日常任务")
#         # check_page_task(0)
#         start_daily_task()

#     tasks = config.get("basic.cycle.tasks", [])

#     if "box" in tasks:
#         start_box()

#     if "ad" in tasks:
#         start_ad()

#     if "pig" in tasks:
#         start_pig()

#     sys_back()
#     app_page_state = 'home'
#     if cycle_low_coin:
#         """金币数过低，做活跃"""
#         save_data_with_obj(
#             {
#                 "watched_recommend_count": 0,
#                 "recommend_executed": False,
#                 "search_execute_count": 0,
#                 "search_executed": False,
#                 "searched_count": 0,
#                 "hot_executed": False,
#                 "watched_hot_count": 0,
#             }
#         )
#         rc = config.get("basic.coin.low", 400)
#         ws_report({"message": f"一轮任务金币低于预期{rc},做大活跃一轮,请及时进行干预处理"})
#         start_active_task()
#     else:
#         """执行间歇活跃"""
#         start_interval_task()


def gather_income():
    global app_page_state
    """采集昨日收益"""
    if not check_operation("report_income"):
        res = ocr_screen()
        my_print(f"find_daily 查找收益兑换入口：{res}")
        cash = next(
            (
                item
                for item in res
                if isinstance(item, dict) and "现金收益" in item.get("text")
            ),
            None,
        )
        my_print(f"cash:{cash}")
        if cash:
            cash_pos = cash["text_box_position"][0]
            random_touch(
                (cash_pos[0], cash_pos[1]), (0, 100), (0, 40), tag="去采集昨日收益"
            )
            sleep(5)
            swipe(
                random_pos((width / 2, height - 500), 100, 40),
                random_pos((width / 2, height - 800), 100, 40),
            )
            sleep(2)
            d.screenshot(f"gather_income_{int(time.time())}.jpg")
            try:
                for view in d(textMatches=rf".*{get_previous_date()}+.*元$"):
                    arr = view.get_text().split(f"{get_previous_date()}+ ")
                    desc = arr[0]
                    number = arr[1].split("元")[0]
                    my_print(f"arr:{arr},,desc:{desc},,number:{number}")
                    ws_report(
                        {},
                        real_data={
                            "type": "statistic",
                            "deviceId": d.serial,
                            "userToken": token,
                            "scriptName": SCRIPT_NAME,
                            "serial": str(int(time.time()) * 1000),
                            "statisticType": "cash",
                            "desc": f"{d.serial}-{today}-昨日现金收益情况",
                            "content": {
                                "time": get_previous_date(),
                                "change": float(number),
                                "desc": view.get_text(),
                                "origin": desc,
                            },
                        },
                    )
                    record_operation("report_income")
            except Exception as e:
                my_print(f"采集收益报错：{e}")

            sys_back()
            sleep(5)

            pos = exists(
                Template(
                    r"tpl1744075956673.png",
                    record_pos=(-0.001, 1.003),
                    resolution=(1080, 2340),
                )
            )
            if pos:
                random_touch(pos, 20, 20, tag="点金币活动入口")
                sleep(5)
                app_page_state = "task"


def find_daily(count=0):
    """查找日常任务入口，方便统计金币金额及查找后续任务入口"""
    if count >= 5:
        my_print("未能找到日常任务标识，可能不在任务页")
        return False

    res = ocr_screen()
    my_print(f"find_daily识别结果：{res}")
    daily = next(
        (
            item
            for item in res
            if isinstance(item, dict) and item.get("text") == "日常任务"
        ),
        None,
    )
    if daily:
        pos = daily["text_box_position"][0]
        if pos[1] > 350:
            p1 = random_pos((width / 2, pos[1]), 40, 10, tag="上划起始位置")
            p2 = random_pos((width / 2, 350), 40, 10, tag="上划结束位置")
            swipe(p1, p2, duration=1)
            up_time = read_data("coin_count_up_time", 0)
            if int(time.time()) - up_time > 20 * 1000:
                report_coin_cash()
            return True

    else:
        swipe_screen(3, 0, {"direction": "down"})
        return find_daily(count + 1)


def report_coin_cash():
    """上报金币现金收益"""
    r1 = ocr_screen((0, 0, width, 500))
    my_print(f"找任务位置截屏:{r1}")
    coin = next(
        (
            item
            for item in r1
            if isinstance(item, dict) and item.get("text").startswith("金币收益")
        ),
        None,
    )
    cash = next(
        (
            item
            for item in r1
            if isinstance(item, dict) and item.get("text").startswith("现金收益")
        ),
        None,
    )
    if coin:
        c = coin["text"].split("金币收益")[1].strip()
        c1 = cash["text"].split("现金收益")[1].strip()
        re_count = config.get("basic.coin.target")
        my_print(f"今日金币收益：{c},预期：{re_count},当前现金为：{c1}")
        ws_report({"message": f"今日金币收益：{c},预期：{re_count},当前现金为：{c1}"})
        try:
            int(c)  # 尝试转换为整数
            ws_report(
                {},
                real_data={
                    "type": "statistic",
                    "deviceId": d.serial,
                    "userToken": token,
                    "scriptName": SCRIPT_NAME,
                    "serial": str(int(time.time()) * 1000),
                    "statisticType": "income",
                    "desc": f"{d.serial}-{today}-当前收益",
                    "content": {"coin": int(c), "cash": float(c1)},
                },
            )
            save_data_with_key("total.coin.count", c, SUMMARY_FILE)
            save_data_with_key("coin_count_up_time", int(time.time()))
        except (ValueError, TypeError):
            my_print("解析金币不是数字，不上报")
            pass


def start_daily_task():
    """做日常任务，签到、预约"""
    global cycle_task_done
    result = ocr_screen()
    my_print(f"开始日常任务:{result}")
    signed = check_operation("signed")
    if not signed:

        signin = next(
            (
                item
                for item in result
                if (
                    isinstance(item, dict)
                    and (
                        item.get("text") == "去签到" or item.get("text") == "签到领现金"
                    )
                )
            ),
            None,
        )

        if signin:
            my_print("日常任务-准备签到")
            start_signin(signin)
            sleep(3)
            result = ocr_screen()
        else:
            record_operation("sign")

    pick_order_coin = next(
        (
            item
            for item in result
            if isinstance(item, dict)
            and ("键领金币" in item.get("text") and "明日" not in item.get("text"))
        ),
        None,
    )
    if pick_order_coin:
        my_print("日常任务-领预约金币")
        start_pick_order_coin(pick_order_coin)
        sleep(3)
        result = ocr_screen()

    pre_ordered = check_operation("pre_ordered")
    if not pre_ordered:
        pre_order = next(
            (
                item
                for item in result
                if isinstance(item, dict) and "预约领金币" in item.get("text")
            ),
            None,
        )
        if pre_order:
            my_print("日常任务-预约")
            start_pre_order(pre_order)
            sleep(3)
            # cycle_task_done = True
            # result = ocr_screen()

    # current_hour = int(datetime.now().hour)
    # if (
    #     (current_hour >= 6 and current_hour < 9)
    #     or (current_hour >= 11 and current_hour < 14)
    #     or (current_hour >= 17 and current_hour < 20)
    #     or (current_hour >= 21 and current_hour < 24)
    # ):
    #     my_print("时间段内，检查吃饭")
    #     print(f"ocr结果：{result}")
    #     eat = next((item for item in result if "吃饭打卡赚金" in item["text"]), None)
    #     if eat:
    #         start_eat(eat)
    #         sleep(3)
    #         cycle_task_done = True
    # else:
    #     cycle_task_done = True


# def check_page_task(check_count):
#     global cycle_task_done

#     if check_count > 3:
#         return
#     start_daily_task()

#     swipe_screen(1)
#     if not cycle_task_done:
#         check_page_task(check_count + 1)


def check_task_alert():
    """检测处理弹窗，包含签到、预约等"""
    result = ocr_screen((0, 0, width, height))
    my_print(f"check_task_alert:{result}")
    sign = next(
        (
            item
            for item in result
            if (
                isinstance(item, dict)
                and (
                    ("金币" in item.get("text") and "立即签到" in item.get("text"))
                    or "签到奖励已翻倍" in item.get("text")
                    or "签到领" in item.get("text")
                    or ("领今日奖励" in item.get("text") and "元" in item.get("text"))
                )
            )
        ),
        None,
    )
    ad_sign = next(
        (
            item
            for item in result
            if isinstance(item, dict)
            and ("看视频签到" in item.get("text") and "金币" in item.get("text"))
        ),
        None,
    )
    ksp = next(
        (
            item
            for item in result
            if isinstance(item, dict)
            and ("看视频再" in item.get("text") and "金币" in item.get("text"))
        ),
        None,
    )
    if ksp:
        p = ksp["text_box_position"][0]
        random_touch((p[0], p[1]), (0, 300), (0, 40), tag="检测弹窗-看视频领")
        check_new_ad({"from": "sign"})
        check_task_alert()
        return

    yy = next(
        (
            item
            for item in result
            if isinstance(item, dict) and item.get("text") == "立即预约领金币"
        ),
        None,
    )
    zmkhb = next(
        (
            item
            for item in result
            if isinstance(item, dict) and item.get("text") == "周末开红包"
        ),
        None,
    )

    new_version = next(
        (
            item
            for item in result
            if isinstance(item, dict) and item.get("text") == "以后再说"
        ),
        None,
    )
    if sign and not check_operation("signed"):
        ws_report({"message": "做签到任务，入口：应用内弹窗"})
        d.screenshot(f"sign-alert-{int(time.time())}.jpg")
        pos = sign["text_box_position"][0]
        random_touch((pos[0], pos[1]), (0, 300), (0, 40), tag="检测弹框-签到")
        record_operation("signed")

        save_data_with_key("total.tasks.sign.flag", True, SUMMARY_FILE)
        sleep(2)

        sleep(3)
        res1 = ocr_screen((0, height / 2, width, height))
        qdtx = next(
            (
                item
                for item in res1
                if isinstance(item, dict) and item.get("text") == "签到提醒"
            ),
            None,
        )
        if qdtx:
            sys_back()
            sleep(5)
        check_task_alert()
    elif ad_sign and not check_operation("signed"):
        d.screenshot(f"sign-alert-{int(time.time())}.jpg")
        ad_pos = ad_sign["text_box_position"][0]
        random_touch((ad_pos[0], ad_pos[1]), (0, 300), (0, 50), tag="看视频签到")
        check_new_ad({"from": "sign"})
        check_task_alert()
    if yy:
        d.screenshot(f"pre-order-alert-{int(time.time())}.jpg")
        sys_back()
        sleep(5)
        check_task_alert()
    if zmkhb:
        d.screenshot(f"red-bag-alert-{int(time.time())}.jpg")
        pos = zmkhb["text_box_position"][0]
        # TODO:修改位置
        sys_back()
        sleep(5)
        check_task_alert()
    if new_version:
        pos = new_version["text_box_position"][0]
        random_touch((pos[0], pos[1]), (0, 100), (10, 40), tag="关闭更新版本")


# 吃饭任务
def start_eat(item):
    global today
    current_hour = int(datetime.now().hour)
    eated = False
    t = ""
    if current_hour >= 6 and current_hour < 9:
        my_print("早饭")
        t = "breakfast"
        eated = check_operation("breakfast")

    elif current_hour >= 11 and current_hour < 14:
        my_print("早饭")
        t = "launch"
        eated = check_operation("launch")

    elif current_hour >= 17 and current_hour < 20:
        my_print("晚饭")
        t = "dinner"
        eated = check_operation("dinner")

    elif current_hour >= 21 and current_hour < 24:
        my_print("夜宵")
        t = "nightsnack"
        eated = check_operation("nightsnack")

    if eated or t == "":
        return
    my_print("吃饭任务")
    pos = item["text_box_position"][0]
    random_touch((pos[0], pos[1]), (0, 400), (0, 100), tag="吃饭任务")
    sleep(6)
    lq1 = d(
        textMatches="^领取.*补贴.*金币$",
        className="com.lynx.tasm.behavior.ui.text.FlattenUIText",
    )
    if lq1.exists:
        # random_touch(trans_abs_pos(lq1.get_position()), 150, 40, tag="吃饭领补贴")
        random_touch_u2(lq1, tag="吃饭领补贴")
        sleep(3)

    else:
        my_print("非直接领模式")
    lq = d(
        textMatches="^看指定视频领.*",
        className="com.lynx.tasm.behavior.ui.text.FlattenUIText",
    )
    if lq.exists:
        random_touch_u2(lq, tag="吃饭看视频后领奖励")
        # random_touch(
        #     trans_abs_pos(lq.get_position()), 150, 40, tag="吃饭看视频后领奖励"
        # )
        sleep(3)
        check_new_ad({"from": f"eat{t}"})
    else:
        my_print("非视频领模式")

    ksp = d(
        textMatches=".*看视频再领.*金币$",
        className="com.lynx.tasm.behavior.ui.LynxFlattenUI",
    )
    if ksp.exists:
        random_touch_u2(ksp, tag="吃饭领后看视频")
        # random_touch(trans_abs_pos(ksp.get_position()), 100, 20, "吃饭领后看视频")
        check_new_ad({"from": f"eat{t}"})
    bl = d(
        textMatches="点击补领", className="com.lynx.tasm.behavior.ui.text.FlattenUIText"
    )
    if bl.exists:
        # random_touch(trans_abs_pos(bl.get_position()), 80, 20, tag="吃饭补领")
        random_touch_u2(bl, tag="吃饭补领")
        check_new_ad({"from": "eat"})
    else:
        my_print("未找到补领按钮")
    record_operation(t)
    sys_back()


# 签到任务
def start_signin(s):
    """开始签到任务"""
    pos = s["text_box_position"][0]
    random_touch((pos[0], pos[1]), (-200, 100), (0, 50), tag="开始签到")
    sleep(3)
    result = ocr_screen((0, 0, width, height))
    my_print(f"start_signin:{result}")
    d.screenshot(f"sign-touch-{int(time.time())}.jpg")
    # 立即签到
    ljqd = next(
        (
            item
            for item in result
            if isinstance(item, dict)
            and (
                ("立即签到" in item.get("text") and "金币" in item.get("text"))
                or "签到奖励已翻倍" in item.get("text")
                or ("领今日奖励" in item.get("text") and "元" in item.get("text"))
            )
        ),
        None,
    )

    ad_sign = next(
        (
            item
            for item in result
            if (
                isinstance(item, dict)
                and ("看视频签到" in item.get("text") and "金币" in item.get("text"))
            )
        ),
        None,
    )

    if ljqd:
        pos1 = ljqd["text_box_position"][0]

        random_touch((pos1[0], pos1[1]), (0, 300), (0, 50), tag="点立即签到")
        record_operation("signed")
        save_data_with_key("total.tasks.sign.flag", True, SUMMARY_FILE)
        ws_report({"message": "做签到任务，入口：任务页"})

        sleep(5)

        ocr_res = ocr_screen()
        my_print(f"ocr_res:{result}")
        # 看视频
        ksp = next(
            (
                item
                for item in ocr_res
                if (
                    isinstance(item, dict)
                    and (
                        ("看视频再" in item.get("text") and "金币" in item.get("text"))
                        or ("看广告再赚" in item.get("text"))
                    )
                )
            ),
            None,
        )
        if ksp:
            p = ksp["text_box_position"][0]
            random_touch((p[0], p[1]), (0, 300), (0, 40), tag="签到后看视频")
            check_new_ad({"from": "sign"})
        else:
            # 签到提醒
            qdtx = next(
                (
                    item
                    for item in ocr_res
                    if isinstance(item, dict) and item.get("text") == "签到提醒"
                ),
                None,
            )
            if qdtx:
                sys_back()
                sleep(5)
                # pos1 = qdtx["text_box_position"][0]
                # random_touch((width / 2, pos1[1] + 205 + height / 2), 10, 10)
                # sleep(5)
    elif ad_sign:
        ad_pos = ad_sign["text_box_position"][0]
        random_touch((ad_pos[0], ad_pos[1]), (0, 300), (0, 50), tag="看视频签到")
        check_new_ad({"from": "sign"})
        record_operation("signed")
    else:
        next_day = next(
            (
                item
                for item in result
                if isinstance(item, dict)
                and ("明日签到" in item.get("text") or "明天再来" in item.get("text"))
            ),
            None,
        )
        if next_day:
            my_print(f"当日签到已完成或者手动签到，标记一下")
            record_operation("signed")


# 领取预约任务
def start_pick_order_coin(item):
    """开始领预约的金币"""
    pos = item["text_box_position"][0]
    random_touch((pos[0], pos[1]), (0, 100), (0, 60), tag="准备领预约金币")
    sleep(3)
    res = ocr_screen()
    my_print(f"start_pick_order_coin:{res}")
    d.screenshot(f"pre-order-touch-{int(time.time())}.jpg")
    # （一键）领取
    lq = next(
        (
            item
            for item in res
            if isinstance(item, dict) and item.get("text") == "一键领取"
        ),
        None,
    )
    if lq:
        pos1 = lq["text_box_position"][0]
        random_touch((pos1[0], pos1[1]), 200, 50, tag="领预约金币")
        ws_report({"message": "领预约金币"})
        sleep(3)
        kxsx = d(text="开心收下", className="com.lynx.tasm.behavior.ui.LynxFlattenUI")
        if kxsx.exists:
            random_touch_u2(kxsx, tag="领完预约金币-开心收下")
            # random_touch(
            #     trans_abs_pos(kxsx.get_position()), 100, 20, tag="领完预约金币-开心收下"
            # )
            sleep(1)
    sys_back()
    sleep(5)
    check_task_alert()


# 预约任务
def start_pre_order(item):
    """开始预约任务"""
    pos = item["text_box_position"][0]
    random_touch((pos[0], pos[1]), (0, 100), (0, 60), tag="去预约")
    sleep(4)
    # 领取
    lq = d(
        text="立即预约领取", className="com.lynx.tasm.behavior.ui.text.FlattenUIText"
    )
    if lq.exists:
        # random_touch(trans_abs_pos(lq.get_position()), 100, 30, tag="点立即预约")
        random_touch_u2(lq, tag="点立即预约")
        record_operation("pre_ordered")
        ws_report({"message": "做预约任务，明日领金币"})
        sleep(4)
        btx = d(
            text="不用提醒我也能来",
            className="com.lynx.tasm.behavior.ui.text.FlattenUIText",
        )
        if btx.exists:
            # random_touch(trans_abs_pos(btx.get_position()), 100, 20)
            sys_back()
            sleep(4)
        # 立即领取
        ljlq = d(
            text="领取奖励", className="com.lynx.tasm.behavior.ui.text.FlattenUIText"
        )
        if ljlq.exists:
            sys_back()
            # random_touch(
            #     trans_abs_pos(ljlq.get_position()), 100, 20, tag="预约后看视频"
            # )
            # check_new_ad({"from": "pre_order"})
    else:
        my_print("无预约按钮")
    sys_back()


# 开宝箱
def start_box():
    global box_time
    global box_time_interval
    global current_gold_task
    global cycle_low_coin
    global cycle_summary

    global cycle_ad_name
    global cycle_ad_coin
    global cycle_total_coin

    cycle_ad_name = []
    cycle_ad_coin = []

    do_count = read_data("total.box.task.count", 0, SUMMARY_FILE)
    max_count = config.get("cycle.box.max", 5)
    if do_count >= max_count:
        ws_report(
            {
                "message": f"已做{do_count +1}轮宝箱任务，最多做{max_count}轮，不再做该任务"
            }
        )
        return

    ws_report({"message": "准备开宝箱"})
    find_res = find_task_entry()
    if not find_res:
        ws_report({"message": "未找到金币任务页入口,无法做宝箱任务"})
        return
    gather_income()

    daily_res = find_daily()
    if not daily_res:
        ws_report({"message": "可能未在任务页,无法做宝箱任务"})
        return
    ocr = ocr_screen((width / 2, height - 800, width, height))
    my_print(f"开宝箱OCR:{ocr}")
    d.screenshot(f"open-box-{int(time.time())}.jpg")
    box = next(
        (
            item
            for item in ocr
            if isinstance(item, dict)
            and (
                item.get("text").startswith("点击领")
                or "开宝箱得金" in item.get("text")
                or "开启神秘宝箱" in item.get("text")
            )
        ),
        None,
    )

    if box:
        pos = box["text_box_position"][0]
        random_touch(
            (pos[0] + width / 2, pos[1] + height - 800),
            (0, 100),
            (0, 40),
            tag="准备开宝箱",
        )
        cycle_total_coin = 0
        ws_report({"message": f"开始今天第{do_count + 1}轮宝箱任务"})
        current_gold_task = "box"
        box_time = int(time.time())
        sleep(3)
        result = ocr_screen((0, 400, width, height - 400))
        my_print(f"开宝箱结果:{result}")
        zd = next(
            (
                item
                for item in result
                if isinstance(item, dict)
                and (item.get("text") == "我知道了" or item.get("text") == "开心收下")
            ),
            None,
        )
        ksp = next(
            (
                item
                for item in result
                if isinstance(item, dict)
                and (
                    "看广告视频" in item.get("text") or "看广告再赚" in item.get("text")
                )
            ),
            None,
        )
        if ksp:
            pos2 = ksp["text_box_position"][0]
            random_touch(
                (pos2[0], pos2[1] + 400), (0, 200), (0, 50), tag="领完宝箱看视频"
            )

            check_new_ad({"from": "box"})

        elif zd:
            pos1 = zd["text_box_position"][0]
            random_touch(
                (pos1[0], pos1[1] + 400), (0, 200), (0, 50), tag="领完宝箱无视频任务"
            )

        ms = ocr_screen((width / 2, height - 500, width, height))
        my_print(f"判断宝箱倒计时:{ms}")
        min = next(
            (
                item
                for item in ms
                if isinstance(item, dict)
                and ("分" in item.get("text") and "秒后领" in item.get("text"))
            ),
            None,
        )
        if min:
            my_print(min["text"])
            box_time_interval = int(min["text"].split("分")[0]) + 1
        current_gold_task = ""
        sleep(3)
        cycle_summary["box.task.count"] = cycle_summary.get("box.task.count", 0) + 1
        save_data_with_key(
            "total.box.task.count", 1, SUMMARY_FILE, {"cumulation": True}
        )
        # if count >= 2:
        #     my_print("已执行2轮，去活跃")
        #     return
        my_print("一轮宝箱结束，查找其他任务")
        report_coin_cash()
        # start_box(count + 1)
    else:
        my_print("不能开宝箱")
        ws_report({"message": "未找到宝箱入口，可能正在倒计时或者入口匹配不成功"})
        min = next(
            (
                item
                for item in ocr
                if isinstance(item, dict)
                and ("分" in item.get("text") and "秒后领" in item.get("text"))
            ),
            None,
        )
        if min:
            my_print(min["text"])
            box_time = int(time.time())
            box_time_interval = int(min["text"].split("分")[0]) + 1
    # 不检测
    # if cycle_low_coin:
    #     my_print("宝箱执行结束，金币低，做活跃")
    #     return
    # excu = config.get("cycle.execute", "ad")
    # if excu == "ad":
    #     start_ad()
    # elif excu == "pig":
    #     start_pig()


def find_ad_pos(c=0):
    """查找ad广入口"""
    adp = exists(
        Template(
            r"tpl1744354367648.png",
            record_pos=(-0.413, 0.378),
            threshold=0.95,
            resolution=(1080, 2340),
        )
    )
    if adp:
        return adp
    else:
        if c > 2:
            return None
        swipe_screen(1)
        return find_ad_pos(c + 1)


# 看广告
def start_ad():
    global cycle_ad_name
    global cycle_ad_coin
    global cycle_total_coin

    cycle_ad_name = []
    cycle_ad_coin = []

    do_count = read_data("total.ad.task.count", 0, SUMMARY_FILE)
    max_count = config.get("cycle.ad.max", 5)
    if do_count >= max_count:
        ws_report(
            {"message": f"已做{do_count +1}轮ad任务，最多做{max_count}轮，不再做该任务"}
        )
        return

    """开始ad广"""
    ws_report({"message": "准备做ad广"})

    find_res = find_task_entry()
    if not find_res:
        ws_report({"message": "未找到金币任务页入口,无法做ad任务"})
        return

    gather_income()

    daily_res = find_daily()
    if not daily_res:
        ws_report({"message": "可能未在任务页,无法做ad任务"})
        return
    global current_gold_task
    global cycle_low_coin
    pos = find_ad_pos()
    if pos:
        random_touch(pos, (0, 400), 60, tag="开始ad广")
        sleep(10)
        adp = find_ad_pos()
        if adp:
            my_print("检测到未正常执行广告，做其他任务")
            ws_report(
                {
                    "message": "找到ad入口，但检测到未正常执行广告，可能在倒计时中，做其他任务"
                }
            )
            return
    else:
        my_print("未找到ad广入口")
        ws_report({"message": "未找到ad广入口"})
        return
    ws_report(
        {
            "message": f'开始今天第{read_data("total.ad.task.count", 0, SUMMARY_FILE) + 1}轮ad广任务'
        }
    )
    cycle_total_coin = 0
    current_gold_task = "ad"
    check_new_ad({"from": "ad"})
    current_gold_task = ""
    report_coin_cash()
    save_data_with_key("total.ad.task.count", 1, SUMMARY_FILE, {"cumulation": True})
    cycle_summary["ad.task.count"] = cycle_summary.get("ad.task.count", 0) + 1


def find_pig_pos(c=0):
    """查找养猪入口"""
    pigp = exists(
        Template(
            r"tpl1744354533449.png",
            threshold=0.95,
            record_pos=(-0.413, 0.433),
            resolution=(1080, 2340),
        )
    )
    if pigp:
        return pigp
    else:
        if c > 2:
            return None
        swipe_screen(1)
        return find_pig_pos(c + 1)


# 养猪
def start_pig():

    do_count = read_data("total.pig.playcount", 0, SUMMARY_FILE)
    max_count = config.get("cycle.pig.max", 5)
    if do_count >= max_count:
        ws_report(
            {
                "message": f"已做{do_count +1}轮养猪任务，最多做{max_count}轮，不再做该任务"
            }
        )
        return

    """开始养猪"""
    ws_report({"message": "准备做养猪任务"})

    find_res = find_task_entry()
    if not find_res:
        ws_report({"message": "未找到金币任务页入口,无法做养猪任务"})
        return
    gather_income()

    daily_res = find_daily()
    if not daily_res:
        ws_report({"message": "可能未在任务页,无法做养猪任务"})
        return
    global current_gold_task
    pos = find_pig_pos()
    if pos:
        random_touch(pos, (0, 400), 60, tag="开始养猪")
        sleep(10)
        back_p = d(description="返回", className="android.widget.ImageView")
        if not back_p.wait(timeout=5):
            my_print("检测到未正常执行养猪，可能在倒计时，做其他任务")
            return
    else:
        my_print("未找到养猪入口")
        ws_report({"message": "未找到养猪任务页入口,无法做养猪任务"})
        return
    global is_suspended
    global pig_time
    is_suspended = False
    ws_report(
        {
            "message": f'开始今天第{read_data("total.pig.play.count", 0, SUMMARY_FILE) + 1}轮养猪任务'
        }
    )
    current_gold_task = "pig"
    obj = {
        "start_time": time_format(),
    }

    def check_time(c, watched=False):
        global is_suspended
        stoped = d(text="回任务页", className="android.widget.TextView")
        if stoped.exists:
            # ws_report(
            #     {
            #         "message": f"养猪一轮结束,开始时间：{obj.get('start_time')},结束时间:{time_format()}"
            #     }
            # )
            return

        suspend = d(text="已暂停", className="android.widget.TextView")
        if suspend.exists:
            my_print("检测到暂停")
            watched = False
            sleep(random.randint(5, 15))
            end_back = config.get("coin.pig.on.coin.stop.back", False)
            if is_suspended:
                if end_back:
                    my_print("两次连续检测到暂停，停止养猪")
                    ws_report(
                        {
                            "message": f"养猪一轮结束,开始时间：{obj.get('start_time')},结束时间:{time_format()}"
                        }
                    )
                    return
                else:
                    my_print("两次连续检测到暂停，继续看剩余视频")
                    sleep(random.randint(30, 40))
                    swipe_screen(1)
                    is_suspended = True
                    check_time(c + 1, watched)
            else:
                my_print("检测到暂停，换下一个")
                swipe_screen(1)
                is_suspended = True
                check_time(c + 1, watched)

        else:
            sleep(4)
            my_print("未检测到暂停，继续检测")
            is_suspended = False
            check_time(c + 1, watched)

    check_time(0)
    sys_back()
    sleep(1)
    goon = d(text="坚持退出", className="com.lynx.tasm.behavior.ui.view.UIView")
    if goon.exists:
        # random_touch(trans_abs_pos(goon.get_position()), 100, 20)
        random_touch_u2(goon)
    ws_report(
        {
            "message": f"看完一轮小猪，开始时间{obj.get('start_time', '')},结束时间:{time_format()}"
        }
    )

    current_gold_task = ""
    sleep(2)
    report_coin_cash()
    cycle_summary["pig.task.count"] = cycle_summary.get("pig.task.count", 0) + 1
    save_data_with_key("total.pig.play.count", 1, SUMMARY_FILE, {"cumulation": True})
    pig_time = int(time.time())


# ============活跃任务相关============
# TODO:修改任务
# def start_active_task(param={}):
#     global start_time
#     diff = int(time.time()) - start_time
#     t = config.get("basic.cycle.time", 180)
#     if diff > random.randint(t - 10, t + 10) * 60:
#         my_print("超时结束脚本")
#         end_script({"reason": "到时间退出"})
#         return
#     sort = config.get("active.plan.order", "123")
#     if sort.startswith("1"):
#         start_recommend()
#     if sort.startswith("2"):
#         start_hot()
#     if sort.startswith("3"):
#         start_search()


def start_interval_task():

    global cycle_total_coin
    global cycle_ad_coin
    global cycle_ad_name
    global cycle_interval_add

    interval_kill = config.get("basic.gold.task.end.kill", False)
    # if interval_kill:
    if False:
        # TODO:修改上报内容
        ws_report(
            {},
            real_data={
                "type": "request",
                "deviceId": d.serial,
                "userToken": token,
                "scriptName": SCRIPT_NAME,
                "serial": str(int(time.time()) * 1000),
                "desc": f"{d.serial}-{today}-主动停止调度脚本",
                "content": {
                    "requestType": "stop_schedule",
                    "stop_until": time_format(int(time.time() + 20 * 60)),
                    "always_disable": False,
                    "comment": "",
                },
            },
        )
        end_script({"reason": "一轮金币任务结束，停止脚本等重新拉起"})
        return

    unique_list = list(set(cycle_ad_name))
    if cycle_total_coin >= 5000:
        my_print("金币数大于5千，做推荐页等金币任务")
        ws_report({"message": "一轮金币任务金币数大于5000，做推荐页等金币任务"})

        cycle_interval_add = False

        start_small_active()

    elif cycle_total_coin >= 3000 and len(unique_list) >= 3:
        my_print("增加时长")
        ws_report(
            {
                "message": "一轮金币任务金币数在3000到5000，且广告数>=3，做推荐页时增加时长"
            }
        )
        cycle_interval_add = True
        start_small_active()
    else:
        cycle_interval_add = False
        my_print("做搜索及大家都在搜")
        ws_report(
            {
                "message": f"一轮金币任务金币数{cycle_total_coin},广告去重数:{len(unique_list)}，做搜索"
            }
        )
        start_interval_search()


def start_reopen_active():

    # interval_kill = config.get("basic.gold.task.end.kill", False)
    # if interval_kill
    task_ad_did = check_operation("task_ad_did")
    if not task_ad_did:
        return
    """做完金币任务后重新拉起脚本先执行几分钟活跃"""
    back_to_home()

    def find_entry():
        max_retries = 5
        for count in range(max_retries + 1):
            rc = d(description="推荐，已选中，按钮")
            if rc.exists:
                return True
            rc1 = d(description="推荐，按钮")
            if rc1.exists:
                random_touch_u2(rc1, tag="切换到推荐页")
                sleep(2)
                return True
            my_print("未找到推荐入口")
            if count == max_retries:
                return False
            sleep(2)
        return False

    res = find_entry()
    if not res:
        pass
        # return
    my_print("开始做完金币任务后重新拉起脚本先执行几分钟活跃")

    into_time = int(time.time())

    def check_time(swipe_count):
        current_time = int(time.time())
        interval_time = random.randint(2 * 60, 6 * 60)
        if current_time - into_time > interval_time:
            my_print("到时间做金币任务")
            ws_report(
                {
                    "message": f"做完金币任务后重新拉起脚本先执行几分钟活跃完成，准备做金币任务"
                }
            )
            return

        check_recommend(swipe_count, entry="interval")
        check_time(swipe_count + 1)

    check_time(0)


def start_small_active():
    back_to_home()

    def find_entry():
        max_retries = 5
        for count in range(max_retries + 1):
            rc = d(description="推荐，已选中，按钮")
            if rc.exists:
                return True
            rc1 = d(description="推荐，按钮")
            if rc1.exists:
                random_touch_u2(rc1, tag="切换到推荐页")
                sleep(2)
                return True
            my_print("未找到推荐入口")
            if count == max_retries:
                return False
            sleep(2)
        return False

    res = find_entry()
    if not res:
        pass
        # return
    my_print("开始看推荐")
    global start_time
    diff = int(time.time()) - start_time
    t = config.get("basic.cycle.time", 180)
    if diff > random.randint(t - 10, t + 10) * 60:
        my_print("超时结束脚本")
        end_script({"reason": "到时间退出"})

        return
    into_time = int(time.time())

    def check_time(swipe_count):

        global box_time
        global box_time_interval
        global ad_time
        global ad_time_interval
        global cycle_interval_add
        current_time = int(time.time())
        tasks = config.get("tasks", [])
        if "box" in tasks:
            my_print(
                f"宝箱来看推荐时差-- {box_time} --{current_time - box_time}秒--间隔：{box_time_interval}分"
            )
            interval = (
                random.randint(box_time_interval + 10, box_time_interval + 18) * 60
            )
            # if "ad" in tasks:
            #     # 两个连做，停一会
            #     interval += random.randint(3, 5) * 60
            if cycle_interval_add:
                interval += random.randint(3, 7) * 60
            if current_time - box_time > interval:
                my_print("到时间切换领箱子")
                # start_gold_task()
                ws_report(
                    {
                        "message": f"做小活跃结束，开始时间{time_format(into_time)},结束时间:{time_format()}"
                    }
                )
                return
        elif "ad" in tasks:
            my_print(
                f"ad广来看推荐时差-- {ad_time} --{current_time - ad_time}秒--间隔：{ad_time_interval}分"
            )
            interval = random.randint(ad_time_interval + 10, ad_time_interval + 18) * 60
            if cycle_interval_add:
                interval += random.randint(3, 7) * 60
            if current_time - box_time > interval:
                my_print("到时间切换领ad广")
                # start_gold_task()
                ws_report(
                    {
                        "message": f"做小活跃结束，开始时间{time_format(into_time)},结束时间:{time_format()}"
                    }
                )
                return

        else:
            interval_time = random.randint(10, 20) * 60
            if cycle_interval_add:
                interval_time += random.randint(3, 7) * 60

            if current_time - into_time > interval_time:
                my_print("到时间做金币任务")
                # start_gold_task()
                ws_report(
                    {
                        "message": f"做小活跃结束，开始时间{time_format(into_time)},结束时间:{time_format()}"
                    }
                )
                return

        check_recommend(swipe_count, entry="interval")
        check_time(swipe_count + 1)

    check_time(0)


def start_interval_search():
    """小活跃-搜索"""
    global check_in_app
    back_to_home()

    sleep(5)

    def find_entry():
        max_retries = 5
        for count in range(max_retries + 1):
            search = d(description="搜索", className="android.widget.Button")
            if search.exists:
                # random_touch(
                #     trans_abs_pos(search.get_position()), 10, 10, tag="点搜索图标"
                # )
                random_touch_u2(search, tag="点搜索图标")
                sleep(5)
                return True

            my_print("未找到推荐入口")
            if count == max_retries:
                return False
            sleep(2)
        return False

    res = find_entry()
    if not res:
        my_print("小活跃搜索任务执行失败，未找到搜索页入口")
        ws_report({"message": "小活跃搜索任务执行失败，未找到搜索页入口"})

        return
    find_interval_search_ad({"into_time": int(time.time())})
    # check_in_app = False
    # kill_app()

    # seconds = config.get("basic.kill.sleep", 20)
    # sleep(seconds)
    # start_app(PKG)
    # sleep(random.randint(10, 15))
    # check_in_app = True
    my_print("结束拉新广-小活跃搜索")
    ws_report({"message": "结束拉新广-小活跃搜索"})
    check_task_alert()


# 看推荐页
def start_recommend(param={}):
    # sleep(5)
    tasks = config.get("tasks", [])
    if len(tasks) == 0:
        tasks = ["active"]
    enable = "active" in tasks
    watched = check_operation("recommend_executed")
    if not enable or watched:
        return

    back_to_home()

    def find_entry():
        max_retries = 5
        for count in range(max_retries + 1):

            rc = d(description="推荐，已选中，按钮")
            if rc.exists:
                return True
            rc1 = d(description="推荐，按钮")

            if rc1.exists:

                random_touch_u2(rc1, tag="切换到推荐页")
                sleep(2)
                return True
            my_print("未找到推荐入口")
            if count == max_retries:
                return False
            sleep(2)
        return False

    res = find_entry()
    if not res:
        my_print("推荐任务执行失败，未找到推荐页入口")
        ws_report({"message": "推荐任务执行失败，未找到推荐页入口"})

        return
    into_time = int(time.time())
    my_print("开始今天的活跃-推荐页任务")
    ws_report({"message": "开始今天的活跃-推荐页任务"})

    def check_time(swipe_count):
        watched_count = read_data("watched_recommend_count", 0)
        all_time = config.get("active", {}).get("maxPlayMinutes", 6 * 60) * 60
        random_time = random.randint(all_time - 100, all_time + 100)
        if int(time.time()) - into_time > random_time:
            my_print("推荐页看广告时长够结束，")
            ws_report(
                {
                    "message": f"【推荐页】看广告时长够结束，共看广告{watched_count}个,共上划{swipe_count}次，开始时间：{time_format(into_time)}，结束时间:{time_format()}"
                }
            )
            record_operation("recommend_executed")

            return
        check_recommend(swipe_count)

        check_time(swipe_count + 1)

    def check_count(swipe_count):

        watched_count = read_data("watched_recommend_count", 0)
        all_count = config.get("active", {}).get("maxPlayCount", 9999)
        if watched_count >= all_count:
            record_operation("recommend_executed")
            ws_report(
                {
                    "message": f"【推荐页】看广告结束，共计{watched_count}个,共上划{swipe_count}次，开始时间：{time_format(into_time)}，结束时间:{time_format()}"
                }
            )
            return

        check_recommend(swipe_count)

        check_count(swipe_count + 1)

    mode = config.get("active", {}).get("mode")
    if mode == "by_count":
        check_count(0)
    if mode == "by_duration":
        check_time(0)


def check_recommend(swipe_count=0, entry="active"):
    watched_count = read_data("watched_recommend_count", 0)
    all_count = config.get("active.recommend.mode.value", 9999)

    desc = d(
        resourceId="com.ss.android.ugc.aweme.lite:id/desc",
        className="android.widget.TextView",
    )

    content_type = "video"
    desc_text = ""

    def to_live(is_ad=True):
        random_touch(
            (width / 2, 450),
            150,
            100,
            tag=f"{'广告直播' if is_ad else '普通直播'},推荐页进入直播间",
        )
        watch_live({"from": entry})
        back_to_home()
        save_data_with_key("watched_recommend_count", watched_count + 1)
        ws_report(
            {
                "message": f"""
                    【推荐页】看{'直播广' if is_ad else '普通直播间'}，{watched_count + 1}/{all_count},共计上划:{swipe_count}次
                """
            }
        )

    def check_suprise_type():
        suprise = d(
            resourceId="com.ss.android.ugc.aweme.lite:id/progress",
            className="android.view.View",
        )
        is_suprise = False
        if suprise.exists:

            not_ad_flag = suprise.sibling(className="android.widget.RelativeLayout")
            if not not_ad_flag.wait(timeout=3):
                my_print("检测到惊喜广")
                is_suprise = True

        zbpos = exists(
            Template(
                r"tpl1744343864314.png",
                record_pos=(-0.394, 0.704),
                threshold=0.9,
                resolution=(1080, 2340),
            )
        )
        if zbpos:
            if is_suprise:
                return "ad_live"
            else:
                return "live"
        else:
            if is_suprise:
                return "ad_video"
            else:
                return "video"

    try:
        if desc.exists():
            desc_text = desc.get_text()
            my_print(f"desc内容为:{desc_text}")
            if desc_text.endswith("广告"):
                touch(random_pos((width / 2, height / 2), 100, 100), duration=2)
                sleep(1)

                like = d(text="喜欢该广告", className="android.widget.TextView")
                if like.exists:
                    content_type = "ad_video"
                random_touch((width / 2, 550), 100, 50, tag="关闭长按弹窗")
            else:
                content_type = check_suprise_type()
        else:
            content_type = check_suprise_type()
    except Exception as e:
        my_print(f"查找推荐页desc报错：{e}")
    my_print(f"当前内容判断类型为:{content_type}")
    if content_type.endswith("video"):
        # search_enable = 'people.search' in config.get("basic.cycle.tasks", [])
        # search_count_day = config.get("active.recommend.people.search.count", 5)
        # search_execute_count = read_data("search_execute_count", 0)
        # if content_type.startswith("ad") or (
        #     search_enable and search_execute_count < search_count_day
        # ):
        #     watch_video(
        #         {
        #             "from": "active",
        #             "matched_ad": content_type.startswith("ad"),
        #             "search_execute": search_enable
        #             and search_execute_count < search_count_day,
        #         }
        #     )
        if content_type.startswith("ad"):
            watch_video(
                {
                    "from": "active",
                    "matched_ad": True,
                    "search_execute": False,
                }
            )
            save_data_with_key("watched_recommend_count", watched_count + 1)
            my_print(
                f"推荐页看视频广告，{watched_count + 1}/{all_count}，共计上滑:{swipe_count}次,识别内容为：{desc_text}"
            )
            ws_report(
                {
                    "message": f"【推荐页】看视频广告，{watched_count + 1}/{all_count}，共计上滑:{swipe_count}次,识别内容为：{desc_text}"
                }
            )
        else:

            bgxq = d(text="不感兴趣")

            if bgxq.exists:
                pass
            else:
                search_enable = "people.search" in config.get("tasks", [])
                search_count_day = config.get("active.recommend.people.search.count", 5)
                search_execute_count = read_data("search_execute_count", 0)
                if (
                    entry == "interval"
                    and search_enable
                    and search_execute_count < search_count_day
                ):
                    watch_video(
                        {
                            "from": "active",
                            "matched_ad": False,
                            "search_execute": True,
                        }
                    )

                    # else:
                    #     sec_min = config.get("active.recommend.video.seconds.min", 20)
                    #     sec_max = config.get("active.recommend.video.seconds.max", 50)
                    #     sleep(random.randint(sec_min, sec_max))
                    #     save_data_with_key("watched_recommend_count", watched_count + 1)
                    #     ws_report(
                    #         {
                    #             "message": f"推荐页看普通视频，{watched_count + 1}/{all_count}，共计上滑:{swipe_count}次,识别内容为：{desc_text}"
                    #         }
                    #     )
                else:
                    if check_weight(4):
                        sec_min = config.get("active.recommend.video.seconds.min", 20)
                        sec_max = config.get("active.recommend.video.seconds.max", 50)
                        sleep(random.randint(sec_min, sec_max))
                        save_data_with_key("watched_recommend_count", watched_count + 1)
                        my_print(f"随机命中，看普通直播")
                        ws_report(
                            {
                                "message": f"【推荐页】看普通视频，{watched_count + 1}/{all_count}，共计上滑:{swipe_count}次,识别内容为：{desc_text}"
                            }
                        )
    else:
        if content_type.startswith("ad"):
            to_live()
        else:
            sleep(8)
            ad_comp = d(
                text="广告",
                className="android.widget.TextView",
            )
            if ad_comp.exists:
                my_print("检测到直播间的广告标识")
                to_live()
            else:
                if check_weight(4):
                    to_live(False)

    swipe_screen(1, params={"s": 0})


# 看热点
def start_hot():
    enable = "hot" in config.get("tasks", [])
    watched = read_data("hot_executed", False)
    if not enable or watched:
        return
    back_to_home()

    def find_entry():
        max_retries = 5
        for count in range(max_retries + 1):

            rc = d(description="热点，已选中，按钮")
            if rc.exists:
                return True
            rc1 = d(description="热点，按钮")
            if rc1.exists:
                random_touch_u2(rc1, tag="切换到热点页")

                sleep(2)
                return True
            my_print("未找到热点入口")
            if count == max_retries:
                return False
            sleep(2)
        return False

    res = find_entry()
    if not res:
        my_print(f"推荐热点执行失败，未找到热点入口")
        ws_report({"message": "推荐热点执行失败，未找到热点入口"})
        return

    into_time = int(time.time())
    ws_report({"message": "开始今天的活跃-热点任务"})

    def check_time():
        all_time = config.get("active.hot.mode.time", 10) * 60
        random_time = random.randint(all_time - 100, all_time + 100)
        if int(time.time()) - into_time > random_time:
            record_operation("hot_executed")
            my_print("倒计时结束热点")
            ws_report(
                {
                    "message": f"热点页看时长够结束，开始时间：{time_format(into_time)}，结束时间:{time_format()}"
                }
            )
            return
        min = config.get("active.hot.video.seconds.min", 30)
        max = config.get("active.hot.video.seconds.max", 90)
        sleep(random.randint(min, max))

        swipe_screen(1)
        check_time()

    def check_count():
        # c = int(time.time())
        watched_count = read_data("watched_hot_count", 0)
        all_count = config.get("active.hot.mode.value", 10)
        if watched_count >= all_count:
            my_print("数量够结束热点")
            record_operation("hot_executed")
            sleep(2)
            ws_report(
                {
                    "message": f"【热点】看次数够结束，开始时间：{time_format(into_time)}，结束时间:{time_format()}"
                }
            )

            return
        min = config.get("active.hot.video.seconds.min", 30)
        max = config.get("active.hot.video.seconds.max", 90)
        sleep(random.randint(min, max))
        save_data_with_key("watched_hot_count", watched_count + 1)
        ws_report({"message": f"【热点】看视频，{watched_count + 1}/{all_count}"})
        swipe_screen(1)
        check_count()

    sleep(3)
    swipe(
        random_pos((width / 2, height - 300), 50, 50),
        random_pos((width / 2, height / 2), 50, 50),
    )

    mode = config.get("active.hot.mode", "")
    if mode == "count":
        check_count()
    if mode == "time":
        check_time()


def start_search():
    enable = "search" in config.get("tasks", [])
    executed = check_operation("search_executed")
    search_count = read_data("searched_count", 0)
    tags = config.get("active.key.search.tags", [])
    if not enable or len(tags) == 0 or search_count == len(tags) or executed:
        return

    global check_in_app
    back_to_home()

    sleep(5)

    def find_entry():
        max_retries = 5
        for count in range(max_retries + 1):
            search = d(description="搜索", className="android.widget.Button")

            if search.exists:
                random_touch_u2(search, tag="点搜索图标")
                sleep(5)
                return True

            my_print("未找到推荐入口")
            if count == max_retries:
                return False
            sleep(2)
        return False

    res = find_entry()
    if not res:
        ws_report({"message": "搜索标签任务执行失败，未找到搜索页入口"})

        return
    my_print("开始搜标签")
    ws_report({"messsage": f"开始今天的{search_count}个拉新广-搜索关键词任务"})
    find_search_ad()

    back_to_home()
    refresh_home_recommend()
    ws_report({"message": "结束拉新广-搜索关键词任务"})
    check_task_alert()


def find_interval_search_ad(params={}):
    """小活跃的搜索"""

    into_time = params.get("into_time", 0)
    my_print(f"into_time:{into_time}")
    diff = int(time.time()) - into_time
    my_print(f"diff:{diff}")
    if diff > random.randint(20, 30) * 60:
        my_print("小活跃到时间，执行其他任务")
        ws_report({"message": f"小活跃搜索执行完毕"})
        stop_search()
        return

    def find_tags(refresh):
        filtered_results = []
        for count in range(3):
            ocrres = ocr_screen()
            my_print(f"搜索ocr识别结果:{ocrres}")
            change = next(
                (
                    item
                    for item in ocrres
                    if isinstance(item, dict) and "换一换" in item.get("text")
                ),
                None,
            )
            my_print(f"change：：{change}")
            if change:
                pos_x = change.get("text_box_position")[0][0]
                pos_y = change.get("text_box_position")[0][1]
                if refresh:
                    random_touch((pos_x, pos_y), (0, 80), (0, 40), tag="换标签")
                    sleep(2)
                    return find_tags(False)
                my_print(f"pos_y:{pos_y}")
                for item in ocrres:
                    # 获取文本框的四个顶点坐标
                    box = item.get("text_box_position", [])
                    if not box or len(box) < 4:
                        continue

                    # 获取左上角坐标 (第一个点)
                    top_left = box[0]
                    if len(top_left) < 2:
                        continue

                    # 提取Y坐标并检查是否在范围内
                    y = top_left[1]
                    if pos_y + 60 <= y <= pos_y + 500:
                        filtered_results.append(item)
                return filtered_results
            else:
                my_print(f"第{count}轮没找到")
                if count == 2:
                    return []

    tags = find_tags(check_weight(5))
    my_print(f"要搜的内容为:{tags}")
    if len(tags) == 0:
        my_print("未找到可搜索的标签，执行其他操作")
        ws_report({"message": "无法正常识别ocr后的搜索内容"})
        stop_search()
        return

    content = tags[random.randint(0, len(tags) - 1)]
    ws_report({"message": f"小活跃搜索，内容为{content.get('text')}"})
    c_pos = content.get("text_box_position", [])[0]
    random_touch((c_pos[0], c_pos[1]), (0, 100), (0, 40), tag="点击猜你想搜的标签")
    sleep(3)
    find_ad({"from": "interval"})
    sys_back()
    sleep(3)
    find_interval_search_ad({**params})


def find_search_ad(params={}):
    """搜索任务"""
    tags = config.get("active.key.search.tags", [])
    search_count = read_data("searched_count", 0)
    my_print(f"开始准备搜索{search_count}内容")

    if search_count == len(tags):
        record_operation("search_executed")
        my_print(f"搜索执行完毕")
        ws_report({"message": f"搜索执行完毕"})
        stop_search()

        return
    content = tags[search_count]
    if content.get("count", 0) == 0:
        save_data_with_key("searched_count", search_count + 1)
        find_search_ad({**params})
        return
    ws_report(
        {
            "message": f"准备搜索第：{search_count + 1}轮，内容为{content.get('keywords')},预期看广告数:{content.get('count')}"
        }
    )

    clear = d(
        resourceId="com.ss.android.ugc.aweme.lite:id/btn_clear",
        description="清空",
        className="android.widget.ImageButton",
    )
    if clear.exists():

        random_touch_u2(clear, tag="清空搜索内容")
        sleep(1)
    input_editor = d(
        resourceId="com.ss.android.ugc.aweme.lite:id/et_search_kw",
        className="android.widget.EditText",
    )
    if input_editor.exists:
        my_print(f"搜索:执行{search_count}--{content.get('keywords')}")
        input_editor.set_text(content.get("keywords"))
        sleep(2)
    else:
        my_print("输入框未找到")
        sys_back()
        sleep(2)
        check_search_page_status()

        return

    st = d(description="搜索", text="搜索", className="android.widget.TextView")
    if st.exists:
        # random_touch(trans_abs_pos(st.get_position()), 40, 20, tag="点搜索按钮")
        random_touch_u2(st, tag="点搜索按钮")
        sleep(3)
        find_ad({"from": "search"})
    save_data_with_key("searched_count", search_count + 1)
    find_search_ad({**params})


def find_ad(params={}):
    my_print(f"find_ad:{params}")
    entry = params.get("from", "search")
    index = params.get("index", 0)
    count = params.get("count", 0)
    my_print(f"第{index}轮查找")
    max = 2
    if entry == "search":
        tags = config.get("active.key.search.tags", [])
        search_count = read_data("searched_count", 0)
        content = tags[search_count]
        max = content.get("count", 0) - 1
    if index >= 10 or count > max:

        if entry == "people.search":
            if count > 0:
                search_execute_count = read_data("search_execute_count", 0)
                save_data_with_key("search_execute_count", search_execute_count + 1)
                all_count = config.get("active.recommend.people.search.count", 5)
                ws_report(
                    {
                        "message": f"大家都在搜：{search_execute_count + 1}/{all_count},共看广告{count}个"
                    },
                )
        else:
            ws_report(
                {"message": f"搜索一轮结束,共看广告{count}个"},
            )
        return

    ad1 = d(
        text="广告",
        description="广告",
    )
    executed = False

    if ad1.exists:
        my_print("找到广告控件，执行判断")
        if ad1.info.get("bounds").get("top") < 400:
            swipe_screen(1, params={"half": True, "s": 1, "d": 2})
            find_ad({**params, "index": index, "count": count})
            return
        random_touch_u2(ad1, tag="搜索点击广告控件")
        sleep(15)

        comment_video = d(
            descriptionMatches="^评论.*，按钮$",
            className="android.widget.LinearLayout",
        )

        re_play = d(text="点击重播", className="android.widget.Button")
        if comment_video.wait(timeout=5) or re_play.wait(timeout=3):
            my_print("搜索-普通视频")
            if re_play.exists:
                random_touch_u2(re_play, tag="点击重播")
                sleep(2)

            watch_video({"from": entry})
            sys_back()
            executed = True
        else:
            my_print("搜索-不是普通视频，执行直播判断")

            comment = d(
                textMatches=r"^说点什么.*$", className="android.widget.EditText"
            )
            if comment.wait(timeout=8):
                my_print("搜索-直播间")
                watch_live({"from": entry})
                executed = True
            else:
                my_print("搜索-不是直播，执行商品判断")

                contact = d(text="客服", className="android.widget.TextView")
                if contact.wait(timeout=8):
                    my_print("搜索-商品")
                    swipe_screen(random.randint(3, 6), params={"d": 2})
                    sleep(random.randint(5, 12))
                    sys_back()
                    executed = True
                else:
                    my_print("搜索-不是商品,")
                    # sys_back()

        backed = check_find_ad_status()
        if not backed:
            sys_back()
            sleep(1)
        count = count + 1
        swipe_screen(2, params={"s": 1, "d": 2})
    else:
        my_print("未找到广告")

    swipe_screen(2, params={"half": True, "s": 1, "d": 2})
    return find_ad({**params, "index": index + 1, "count": count})


def check_find_ad_status():
    for count in range(3):

        search = d(description="单双列切换图标", className="android.widget.ImageView")
        if search.wait(timeout=3):
            return True

        if count == 3:
            return False
        sleep(2)


def stop_search():
    sys_back()
    sleep(2)
    sys_back()
    sleep(2)
    check_search_page_status()

    # tasks = config.get("basic.cycle.tasks", [])
    # if "box" in tasks or "ad" in tasks or "pig" in tasks:
    #     start_gold_task()
    # else:
    #     start_active_task()


def check_search_page_status() -> bool:
    for _ in range(10):
        if not is_app_home():
            sys_back()
            sleep(3)
        else:
            return True
    my_print(f"结束搜索并返回首页失败")
    return False


# ===========公共方法==========


def kill_app():
    d.press("recent")
    # keyevent("KEYCODE_APP_SWITCH")
    sleep(2)
    douyin = d(description="抖音极速版", className="android.widget.FrameLayout")
    if douyin.exists:
        douyin.swipe("up", steps=10)
        # douyin_pos = douyin.get_position()
        # swipe(douyin_pos, (douyin_pos[0], 0.1))
        # d.swipe_ext("up", scale=0.7)


# 看普通视频
def watch_video(params={}):
    global cycle_summary
    entry = params.get("from", "")
    matched_ad = params.get("matched_ad", False)
    search_execute = params.get("search_execute", False)
    execute = True
    if entry == "active" and not matched_ad:
        execute = False
    my_print(f"execute:{execute}")
    obj = {}
    if check_weight(config.get("config.video.like.weight")) and execute:
        my_print("触发点赞")

        like_comp = d(
            descriptionMatches="^未点赞.*按钮$",
            className="android.widget.LinearLayout",
        )
        if like_comp.exists:
            obj["like"] = True
            random_touch_u2(like_comp, tag="普通视频点赞")
            cycle_summary["like.count"] = cycle_summary.get("like.count", 0) + 1
            save_data_with_key(
                "total.like.count", 1, SUMMARY_FILE, {"cumulation": True}
            )
            sleep(random.randint(1, 3))

    if check_weight(config.get("config.video.collect.weight")) and execute:
        my_print("触发收藏")
        collect_comp = d(
            descriptionMatches="^未选中，收藏.*按钮$",
            className="android.widget.LinearLayout",
        )
        if collect_comp.exists:
            obj["collect"] = True

            random_touch_u2(collect_comp, tag="普通视频收藏")
            cycle_summary["collect.count"] = cycle_summary.get("collect.count", 0) + 1
            save_data_with_key(
                "total.collect.count", 1, SUMMARY_FILE, {"cumulation": True}
            )
            sleep(random.randint(1, 3))

    if check_weight(config.get("config.video.recommend.weight")) and execute:
        my_print("触发推荐")

        tj = d(textMatches="^共.*人推荐$")
        if tj.exists:
            obj["active"] = True

            random_touch_u2(tj, tag="普通视频推荐")
            cycle_summary["recommend.count"] = (
                cycle_summary.get("recommend.count", 0) + 1
            )
            save_data_with_key(
                "total.recommend.count", 1, SUMMARY_FILE, {"cumulation": True}
            )

    if check_weight(config.get("config.video.focus.weight")) and execute:
        my_print("触发关注")

        gzb = d(description="关注", className="android.widget.Button")
        if gzb.exists:
            gzi = gzb.child(className="android.widget.ImageView")

            if gzi.exists:

                random_touch_u2(gzi, tag="普通视频关注")
                obj["focus"] = True
                cycle_summary["focus.count"] = cycle_summary.get("focus.count", 0) + 1
                save_data_with_key(
                    "total.focus.count", 1, SUMMARY_FILE, {"cumulation": True}
                )

    if check_weight(config.get("config.video.comment.weight")) or entry == "active":

        comment_comp = d(
            descriptionMatches="^评论.*，按钮$",
            className="android.widget.LinearLayout",
        )
        if comment_comp.exists:
            no_comment = False
            text = comment_comp.info.get("contentDescription", "").split("，按钮")[0]
            my_print(f"评论数量为：{text}")
            if text.endswith("评论"):
                no_comment = True
            random_touch_u2(comment_comp, tag="点击普通视频评论")

            sleep(2)
            comment_editor1 = d(
                className="android.widget.EditText",
                focused=True,
            )
            if comment_editor1.exists or no_comment:
                sys_back()

            if search_execute:
                my_print("推荐页进入大家都在搜判断")
                search = d(text="大家都在搜：", className="android.widget.TextView")
                if search.exists:
                    search_content = search.sibling(textMatches="^(?!.*大家都在搜).*$")
                    if search_content.exists:
                        my_print(f"大家都在搜：{search_content.info.get('text')}")
                        random_touch_u2(search_content, tag="进入大家都在搜")
                        check_recommend_search()
                else:
                    my_print("没有大家都在搜入口")

            if check_weight(config.get("config.video.comment.weight")) and execute:
                my_print("准备执行评论")
                comment_emoji = [
                    "[666]",
                    "[比心]",
                    "[爱心]",
                    "[玫瑰]",
                    "[赞]",
                    "[鼓掌]",
                    "[舔屏]",
                    "[送心]",
                ]

                emoji = comment_emoji[random.randint(0, len(comment_emoji) - 1)]
                emoji_repeat = random.randint(3, 8)
                comment_text = emoji * emoji_repeat

                comment_content = d(
                    resourceId="com.ss.android.ugc.aweme.lite:id/content"
                )
                if comment_content.count > 1:
                    comment_text = comment_content[1].get_text()
                # comments_container = d(
                #     className="androidx.recyclerview.widget.RecyclerView"
                # )
                # if comments_container.exists:
                #     all_comments = comments_container.child()
                #     if len(all_comments) > 1:
                #         copy_comment = all_comments[1].offspring(
                #             "com.ss.android.ugc.aweme.lite:id/content",
                #             type="android.widget.TextView",
                #         )
                #         if copy_comment.exists():
                #             comment_text = copy_comment.get_text()
                my_print(f"要发送的数据为：{comment_text}")
                comment_comp = d(
                    className="android.widget.EditText",
                    focused=False,
                )
                if comment_comp.exists:
                    # random_touch(
                    #     trans_abs_pos(comment_comp.get_position()),
                    #     100,
                    #     20,
                    #     tag="点击评论框",
                    # )
                    random_touch_u2(comment_comp, tag="点击评论框")
                    sleep(2)
                    comment_editor = d(
                        className="android.widget.EditText",
                        focused=True,
                    )
                    if comment_editor.exists:

                        try:
                            comment_editor.set_text(comment_text)
                            sleep(3)
                            send_btn = d(
                                text="发送",
                                className="android.widget.TextView",
                                enabled=True,
                            )
                            if send_btn.exists:
                                my_print("检测到发送按钮")
                                obj["comment"] = True
                                random_touch_u2(send_btn)
                                sleep(2)
                                cycle_summary["comment.count"] = (
                                    cycle_summary.get("comment.count", 0) + 1
                                )
                                save_data_with_key(
                                    "total.comment.count",
                                    1,
                                    SUMMARY_FILE,
                                    {"cumulation": True},
                                )
                            else:
                                my_print("未检测到发送按钮")
                                sys_back()
                                sleep(2)
                        except Exception as e:
                            pass
                        sys_back()
                        sleep(2)
                        notify_alert = d(text="及时获得评论回复提醒")
                        if notify_alert.exists():
                            sys_back()
                    else:
                        my_print("未找到输入框")
                        sys_back()
                        sleep(2)
            else:
                my_print("未触发评论，关闭弹框")
                sys_back()
                sleep(2)

        else:
            my_print("评论入口不存在")
            sleep(random.randint(2, 4))
    sec_min = config.get("active.recommend.video.seconds.min", 20)
    sec_max = config.get("active.recommend.video.seconds.max", 50)

    if entry == "search":
        search_count = read_data("searched_count", 0)
        tags = config.get("active.key.search.tags", [])
        item = tags[search_count]
        sec_min = item.get("video")[0]
        sec_max = item.get("video")[1]

    if entry == "people.search":
        sec_min = config.get("active.recommend.people.search.video.seconds.min", 20)
        sec_max = config.get("active.recommend.people.search.video.seconds.max", 50)
    if entry != "pig" and execute:
        save_data_with_key(
            "total.video.play.count", 1, SUMMARY_FILE, {"cumulation": True}
        )
        cycle_summary["video.play.count"] = cycle_summary.get("video.play.count", 0) + 1

        sleep(
            random.randint(
                sec_min,
                sec_max,
            )
        )


def check_recommend_search():
    sleep(3)
    find_ad({"from": "people.search"})
    sys_back()


# 直播间
def watch_live(params={}):
    global cycle_low_coin
    global cycle_ad_name
    global live_send_ticket_count
    global cycle_summary
    live_send_ticket_count = 0

    ori_data = load_data(SUMMARY_FILE)
    date_entry = ori_data.setdefault(today, {})
    device_entry = date_entry.setdefault(d.serial, {})

    like_calc = device_entry.get("total.like.count", 0)
    gift_calc = device_entry.get("total.gift.count", 0)
    comment_calc = device_entry.get("total.comment.count", 0)
    focus_calc = device_entry.get("total.focus.count", 0)

    into_time = int(time.time())
    obj = {"start_time": time_format()}
    entry = params.get("from", "")

    obj["entry"] = SOURCE_MAP.get(entry, "")
    sleep(random.randint(5, 8))
    isMatchTag = False
    pattern = r".*({}).*".format(
        "|".join(re.escape(kw) for kw in config.get("dev.tags", "").split(","))
    )
    name_text = ""
    target_elements = d(
        # textMatches=pattern,
        className="android.widget.TextView",
        resourceId="com.ss.android.ugc.aweme.lite:id/user_name",
    )
    if target_elements.wait(timeout=3):
        name_text = target_elements.get_text()

        obj["live_name"] = name_text

    sxt = d(text="收下奖励", className="android.widget.TextView")
    if sxt.exists:
        # random_touch(trans_abs_pos(sxt.get_position()), 100, 30, tag="点直播间收下奖励")
        random_touch_u2(sxt, tag="点直播间收下奖励")
        sleep(2)
        random_touch((width / 3, 800), 80, 50, tag="取消弹框")
        sleep(2)

    check_bag_result()

    sleep(5)

    def watch_live_attach(params={}):
        entry = params.get("from", "")
        sleep(random.randint(5, 8))
        if entry == "fengche" or entry == "game":
            swipe_screen(random.randint(1, 4), params={"d": 2})
            sleep(3)

        elif entry == "goods":
            recycle = d(className="androidx.recyclerview.widget.RecyclerView")
            if recycle.exists:
                swipe_screen(random.randint(0, 3), params={"d": 2})
                goods_list = recycle.child()
                my_print(f"商品列表数量:{len(goods_list)}")
                index = random.randint(0, min(goods_list.count - 1, 2))
                goods_item = goods_list[index]
                my_print(f"要点击:{index}")
                random_touch_u2(goods_item, tag="点击商品")
                sleep(2)
                swipe_screen(1)
                # swiper_img = d(
                #     descriptionMatches="^图片.*",
                #     className="android.widget.FrameLayout",
                # )
                # if swiper_img.wait(timeout=5):
                #     random_touch_u2(swiper_img)
                #     sleep(2)
                #     for i in range(random.randint(1, 3)):
                #         swipe(
                #             random_pos((width - 80, height / 2), 20, 20),
                #             random_pos((width / 2 - 50, height / 2), 20, 20),
                #             duration=0.2,
                #         )
                #         sleep(random.randint(1, 4))
                #     sys_back()
                swipe_screen(random.randint(1, 3))
                recommend_btn = d(text="评价", className="android.widget.Button")
                if recommend_btn.exists:
                    random_touch_u2(recommend_btn)

                    sleep(2)
                    all_recommend = d(
                        text="商品评价", className="android.widget.TextView"
                    )
                    if all_recommend.exists:

                        random_touch_u2(all_recommend)
                        sleep(2)

                        for i in range(random.randint(1, 5)):
                            img = d(
                                descriptionMatches="^评价图片.*",
                                className="android.widget.Button",
                            )
                            if img.exists:
                                random_touch_u2(img)

                                sleep(2)
                                for i in range(random.randint(0, 5)):
                                    swipe(
                                        random_pos((width - 80, height / 2), 20, 20),
                                        random_pos(
                                            (width / 2 - 50, height / 2), 20, 20
                                        ),
                                        duration=0.2,
                                    )
                                    sleep(random.randint(1, 4))
                                sys_back()
                            swipe_screen(random.randint(1, 2))
                        sys_back()

                detail_btn = d(text="详情", className="android.widget.Button")
                if detail_btn.exists:
                    random_touch_u2(detail_btn)

                    sleep(2)

                swipe_screen(
                    random.randint(5, 15), params={"s": random.randint(2, 4), "d": 2}
                )

                sys_back()
            else:
                my_print("未找到弹窗商品列表")
        elif entry == "house":
            swipe_screen(random.randint(1, 4))

        sys_back()
        sleep(2)
        random_touch((width / 2, 500), 20, 20, 2)
        records = obj.get("records", [])
        records.append({"time": time_format(), "desc": "查看直播间福利/游戏手柄"})
        obj["records"] = records
        my_print("查看直播福利完成")

    game_comp = d(descriptionMatches="^小手柄.*", className="android.widget.ImageView")

    if game_comp.exists:
        random_touch_u2(game_comp, tag="直播间看游戏详情")
        watch_live_attach({"from": "game"})
    else:

        fuli = d(description="福利领取入口", className="android.widget.FrameLayout")
        if fuli.exists:
            random_touch_u2(fuli, tag="直播间看福利详情")
            watch_live_attach({"from": "fengche"})
        else:
            goodsp = d(description="商品列表", className="android.widget.Button")
            if goodsp.exists:
                random_touch_u2(goodsp, tag="直播间看商品列表")
                watch_live_attach({"from": "goods"})
            else:
                h = d(
                    description="小房子，按钮", className="android.widget.FrameLayout"
                )
                if h.exists():
                    random_touch_u2(h, tag="点击直播间小房子")
                    watch_live_attach({"from": "house"})

    if check_weight(config.get("live.weight.focus", 0)) and isMatchTag:
        gz = d(text="关注", className="android.widget.TextView")
        if gz.exists:
            random_touch_u2(gz, tag="直播间关注")
            sleep(5)
            sys_back()
            random_touch((width / 3, 550), 50, 30)
            records = obj.get("records", [])
            records.append({"time": time_format(), "desc": "关注直播间"})
            obj["records"] = records
            focus_calc = focus_calc + 1

            cycle_summary["focus.count"] = cycle_summary.get("focus.count", 0) + 1
        else:
            my_print("直播间未找到关注按钮")
    like_count = config.get("config.live.like.top.count", 10)
    comment_count = config.get("config.live.comment.count", 1)

    seconds_min = config.get("active.recommend.live.minutes.min", 3) * 60
    seconds_max = config.get("active.recommend.live.minutes.max", 5) * 60
    if entry == "search":
        search_count = read_data("searched_count", 0)
        tags = config.get("active.key.search.tags", [])
        item = tags[search_count]

        seconds_min = item.get("live")[0] * 60
        seconds_max = item.get("live")[1] * 60

    if entry == "people.search":
        seconds_min = (
            config.get("active.recommend.people.search.live.minutes.min", 3) * 60
        )
        seconds_max = (
            config.get("active.recommend.people.search.live.minutes.max", 5) * 60
        )
    if entry == "interval":
        seconds_min = 3 * 60
        seconds_max = 7 * 60
    if entry == "box":
        sec = config.get("coin.box.live.seconds", 60)
        seconds_min = sec - 10
        seconds_max = sec + 10

    if entry == "pig":
        sec = config.get("coin.pig.live.seconds", 60)
        seconds_min = sec - 10
        seconds_max = sec + 10

    if entry == "ad":
        sec = config.get("coin.ad.live.seconds", 60)
        seconds_min = sec - 10
        seconds_max = sec + 10
        # like_count = config.get("basic.live.likes.count.ad", 10)
        # comment_count = config.get("basic.live.comment.count.ad", 1)

    if comment_count > 0:
        do_live_comment(obj)

    open_box = config.get("basic.live.small.box.flag", False)
    if entry == "box" or entry == "pig" or entry == "ad":
        cycle_ad_name.append(name_text)
        my_print("金币任务看直播")
        check_bag_result()
        if like_count > 0:
            do_live_like(obj)

        if open_box:
            check_live_box(obj)

        sec = config.get("live.seconds.min", 60)
        sleep(random.randint(seconds_min, seconds_max))
        check_bag_result()
    else:
        random_time = int(time.time()) + random.randint(seconds_min, seconds_max)
        bag_opened = False
        while time.time() < random_time:
            check_bag_result()
            # sleep(random.randint(10, 20))
            if obj.get("likes_count", 0) < like_count:
                do_live_like(obj)
            if open_box:
                sleep(random.randint(10, 20))
                check_live_box(obj)

            sleep(random.randint(10, 20))
            # send_ticket(obj)
            if not bag_opened:
                bag = d(descriptionMatches="^福袋.*", className="android.widget.Button")
                if bag.exists:
                    # random_touch(
                    #     trans_abs_pos(bag.get_position()), 10, 10, tag="直播间开福袋"
                    # )
                    random_touch_u2(bag, tag="直播间开福袋")
                    sleep(5)
                    joined = d(text="已参与", className="android.widget.Button")
                    if joined.exists:
                        my_print("已参与福袋")
                        sys_back()
                        bag_opened = True
                        # 延长直播观看时间
                        bag_timeout_minutes = "0"
                        bag_timeout_seconds = "0"
                        bag_timeout_str = bag.info["contentDescription"].split("，")[1]
                        my_print(f"福袋剩余时间：{bag_timeout_str}")
                        if "分" in bag_timeout_str:
                            bag_timeout_minutes = bag_timeout_str.split("分")[0]
                            bag_timeout_seconds = bag_timeout_str.split("分")[
                                1
                            ].replace("秒", "")
                        elif "秒" in bag_timeout_str:
                            bag_timeout_seconds = bag_timeout_str.replace("秒", "")
                        bag_timeout = (
                            int(time.time())
                            + int(bag_timeout_minutes) * 60
                            + int(bag_timeout_seconds)
                            + random.randint(20, 30)
                        )
                        random_time = max(bag_timeout, random_time)
                        my_print(f"有福袋，延长直播时间到{time_format(random_time)}")
                    else:
                        pub = d(text="去发表评论", className="android.widget.Button")
                        if pub.exists:
                            # random_touch(trans_abs_pos(pub.get_position()), 20, 20)
                            random_touch_u2(pub, tag="开福袋去发表评论")
                            sleep(3)
                            send_btn = d(text="发送", className="android.widget.Button")
                            if send_btn.exists:
                                # my_print("发表评论点发送按钮")
                                # random_touch(
                                #     trans_abs_pos(send_btn.get_position()), 20, 20
                                # )
                                random_touch_u2(send_btn, tag="发表评论点发送按钮")
                                # 上报数据
                                sleep(2)
                                # bag_opened = True
                                records = obj.get("records", [])
                                records.append(
                                    {
                                        "time": time_format(),
                                        "desc": "直播间开福袋",
                                    }
                                )
                                obj["records"] = records
                            else:
                                my_print("未找到发送按钮")
                        else:
                            fans = d(
                                textMatches="^加入粉丝团.*",
                                className="android.widget.Button",
                            )
                            if fans.exists:
                                sys_back()
                                bag_opened = True
                                my_print("要加粉丝团，未执行")
                            else:
                                my_print("开福袋未找到评论按钮")

    my_print("看直播结束，返回")
    check_bag_result()
    sys_back()
    sleep(1)
    small_window = d(text="暂时不用", className="android.widget.TextView")
    if small_window.exists:
        random_touch_u2(small_window)
    records = obj.get("records", [])
    records.append({"time": time_format(), "desc": f"退出直播间"})
    obj["records"] = records
    obj["end_time"] = time_format()
    pattern = r".*({}).*".format(
        "|".join(re.escape(kw) for kw in ["直播已结束", "后进入下场直播"])
    )
    ws_report(
        {
            "message": f"【{obj.get('entry','来源未知')}】看直播结束，直播间名称：{obj.get('live_name', '未获取到')},点赞共计:{obj.get('likes_count', 0)}次,评论共:{obj.get('comment_count', 0)}条，进入时间：{obj.get('start_time', '')},退出时间:{obj.get('end_time', '')},操作记录：{obj.get('records', [])}",
            # "content": obj,
        }
    )

    live_calc = device_entry.get("total.live.play.count", 0)
    calc_obj = {
        "total.like.count": like_calc + obj.get("likes_count", 0),
        "total.comment.count": comment_calc + obj.get("comment_count", 0),
        "total.gift.count": gift_calc + live_send_ticket_count,
        "total.focus.count": focus_calc,
        "total.live.play.count": live_calc + 1,
    }
    save_data_with_obj(calc_obj, SUMMARY_FILE)

    cycle_summary["like.count"] = cycle_summary.get("like.count", 0) + obj.get(
        "likes_count", 0
    )
    cycle_summary["comment.count"] = cycle_summary.get("comment.count", 0) + obj.get(
        "comment_count", 0
    )
    cycle_summary["gift.count"] = (
        cycle_summary.get("gift.count", 0) + live_send_ticket_count
    )
    cycle_summary["live.play.count"] = cycle_summary.get("live.play.count", 0) + 1
    my_print(f"直播结束obj:{obj}")
    target_elements = d(textMatches=pattern, className="android.widget.TextView")
    if target_elements.exists:
        sys_back()
    sleep(2)


# 送人气票
def send_ticket(obj={}):
    global live_send_ticket_count
    send_count_day = read_data().get("send_ticket_count", 0)
    remote_count_day = config.get("live.count.ticket.day", 5)
    my_print(f"今日送人气票{send_count_day},上限:{remote_count_day}")
    if send_count_day >= remote_count_day:
        my_print("今日送人气票已达上限")
        return
    remote_count = config.get("live.count.ticket", 1)
    my_print(f"直播间赠送上限:{remote_count}，已送数量：{live_send_ticket_count}")
    if live_send_ticket_count < remote_count:
        my_print("开始送人气票")
        gift = d(description="礼物", className="android.widget.Button")
        if gift.exists:
            # random_touch(trans_abs_pos(gift.get_position()), 15, 15)
            random_touch_u2(gift, tag="点击送礼物")
            sleep(2)

            balance_parent = d(
                descrictionMatches="^余额.*充值$", className="android.widget.Button"
            )
            if balance_parent.exists:
                balance = balance_parent.child(
                    textMatches=number_pattern, className="android.widget.TextView"
                )
                if balance.exists:
                    amount = int(balance.get_text())
                    if amount < 1:
                        my_print("钻石金额不足，无法赠送")
                        random_touch((width / 3, 800), 50, 30, tag="关闭送礼物弹窗")
                        return
                else:
                    my_print("未找到余额，无法赠送")
                    random_touch((width / 3, 800), 50, 30, tag="关闭送礼物弹窗")
                    return
            else:
                my_print("未找到余额，无法赠送")
                live_send_ticket_count = remote_count
                random_touch((width / 3, 800), 50, 30, tag="关闭送礼物弹窗")
                return

            ticket = d(
                descriptionMatches="^人气票.*", className="android.widget.Button"
            )
            if ticket.exists:
                text = ticket.info.get("contentDescription", "")
                if text.endswith("双击赠送"):
                    # random_touch(trans_abs_pos(ticket.get_position()), 30, 30)
                    random_touch_u2(ticket)
                    sleep(1)
                else:
                    # random_touch(trans_abs_pos(ticket.get_position()), 30, 30)
                    random_touch_u2(ticket)
                    sleep(1)
                    # random_touch(trans_abs_pos(ticket.get_position()), 30, 30)
                    random_touch_u2(ticket)
                    sleep(1)
                    live_send_ticket_count = live_send_ticket_count + 1
                    records = obj.get("records", [])
                    records.append({"time": time_format(), "desc": "赠送人气票"})
                    obj["records"] = records
                    save_data_with_key("send_ticket_count", send_count_day + 1)
                    sys_back()
            else:
                my_print("未找到人气票,关闭弹框")
                sys_back()

        else:
            my_print("未找到礼物入口")


def check_bag_result():
    target_elements = d(text="查看幸运观众", className="android.widget.TextView")
    if target_elements.exists:
        my_print("福袋结果出现，关闭")
        sys_back()
        sleep(2)


def do_live_comment(obj={}):
    comment = d(textMatches=r"^说点什么.*$", className="android.widget.EditText")
    if comment.exists:
        my_print("找到评论入口")
        random_touch_u2(comment, tag='tag="直播间评论入口"')
        sleep(2)
        comment_editor = d(focused=True, className="android.widget.EditText")
        if comment_editor.exists:
            # content = comment_list[random.randint(0, len(comment_list) - 1)]
            # comment_content = content
            comment_content = get_comment_by_time()
            try:
                my_print(f"直播间评论:{comment_content}")
                comment_editor.set_text(comment_content)
                sleep(3)
                send_btn = d(text="发送", className="android.widget.Button")
                if send_btn.exists:
                    random_touch_u2(send_btn, tag='tag="直播间评论发送"')
                    records = obj.get("records", [])
                    comment_count = obj.get("comment_count", 0)
                    records.append(
                        {
                            "time": time_format(),
                            "desc": f"直播间发送评论{comment_content}",
                        }
                    )
                    obj["records"] = records
                    obj["comment_count"] = comment_count + 1
                    sleep(2)
                else:
                    my_print("未检测到发送按钮")
                    sys_back()
                    sleep(2)
            except Exception as e:
                my_print(e)
                pass
            sleep(random.randint(5, 10))
    else:
        my_print("未找到评论入口")


def check_live_box(obj={}):
    # 开宝箱活跃
    ljb = d(text="领金币", className="com.lynx.tasm.behavior.ui.view.UIView")
    if ljb.exists:
        random_touch_u2(ljb, tag="点直播间小宝箱入口")
        sleep(5)
        kbxpos = d(resourceIdMatches=r"^dailyBox.*$").child(
            text="开宝箱", className="android.widget.TextView"
        )
        if kbxpos.exists:
            random_touch_u2(kbxpos, tag="领直播间宝箱")
            sleep(8)
            sys_back()
            sleep(1)
            sys_back()
            my_print("直播宝箱完成")
            random_touch((width / 3, 550), 40, 20)
            records = obj.get("records", [])
            records.append({"time": time_format(), "desc": "直播间开小宝箱"})
            small_box_count = obj.get("small_box_count", 0)
            obj["small_box_count"] = small_box_count + 1
            obj["records"] = records
            sleep(1)
            random_touch((width / 3, 550), 40, 20)
        else:
            sys_back()
    else:
        my_print("直播间小宝箱不存在")


def do_live_like(obj={}):
    count = random.randint(5, 10)
    records = obj.get("records", [])
    likes_count = obj.get("likes_count", 0)
    records.append({"time": time_format(), "desc": f"直播间点赞{count}次"})
    obj["records"] = records
    obj["likes_count"] = likes_count + count
    for i in range(count):
        random_touch((width / 4, height / 2 - 250), 30, 30, tag="直播间点赞")
        sleep(0.1)


# 滑多半屏，保证能上划到新视频
def swipe_screen(mc=9, c=0, params={}):
    d = params.get("d", 0.1)
    s = params.get("s", random.randint(1, 3))
    half = params.get("half", False)
    direction = params.get("direction", "up")
    if c == mc:
        return
    p1 = random_pos((width / 2, height - 480), 40, 30, tag="滑屏起始位置")
    p2 = random_pos(
        (width / 5 * 3.3, height / 2 - 500 if half else 500), 40, 30, tag="滑屏结束位置"
    )
    my_print(f"p1:{p1},,p2:{p2}")
    if direction == "up":
        # d.swipe(p1[0]/width, p1[1]/height, p2[0]/width, p2[1]/height, duration=d)
        swipe(p1, p2, duration=d)
    else:
        swipe(p2, p1, duration=d)
        # d.swipe(p2[0]/width, p2[1]/height, p1[0]/width, p1[1]/height, duration=d)

    sleep(s)
    swipe_screen(mc, c + 1, {**params})


def wait_ad_end(repeat=False, options={}):
    global ad_live_entered
    global cycle_ad_name
    global current_gold_task
    global check_in_app
    entry = options.get("from", "")
    ad_live_entered = False
    cycle_wait = random.randint(35, 45)
    if not repeat:
        # sleep(3)
        leiji = d(
            text="直播间观看时长计入奖励时长",
            className="com.lynx.tasm.behavior.ui.text.FlattenUIText",
        )

        if leiji.wait(timeout=3):

            random_touch_u2(leiji, tag="直播广告提前进入")
            ad_live_entered = True
            cycle_wait = 5
            watch_live({"from": current_gold_task})

    else:
        pass

    sleep(3 if repeat else cycle_wait)
    zbj = d(text="说点什么...", className="android.widget.EditText")
    back = d(description="返回", className="android.widget.Button")
    if zbj.wait(timeout=3):
        """判断是直播间"""
        ad_live_entered = True
        watch_live({"from": current_gold_task})

    if back.wait(timeout=3):
        """判断是普通视频"""
        if check_weight(config.get("basic.gold.active.weight", 0)):
            """检测权重触发后才执行活跃"""
            swipe_screen(random.randint(1, 3))
            sleep(2)
            open_count = read_data(f"{entry}_open_app_count", 0)
            all_count = config.get(f"coin.{entry}.video.detail.count", 3)
            enable = config.get(f"coin.{entry}.other.app.enable")
            seconds = config.get(f"coin.{entry}.other.app.seconds", 30)
            if enable and open_count < all_count:
                open_comp = d(text="立即打开", className="android.widget.TextView")
                if open_comp.exists:
                    check_in_app = False
                    random_touch_u2(open_comp)
                    sleep(seconds)
                    start_app(PKG)
                    save_data_with_key(f"{entry}_open_app_count", open_count + 1)
                    check_in_app = True
            sys_back()
            sleep(2)

    end = d(
        textMatches="^领取成功.*", className="com.lynx.tasm.behavior.ui.view.UIView"
    )

    try:
        if end.exists:
            my_print("检测到广告结束")
            # 添加二次校验，防止检测到结束时正好跳转详情
            if back.wait(timeout=5):
                # swipe_screen(random.randint(1, 3))
                sleep(2)
                sys_back()

            zbj = d(
                textMatches=".*进入直播.*",
                className="com.lynx.tasm.behavior.ui.text.FlattenUIText",
            )
            if zbj.wait(timeout=3):

                if not ad_live_entered:
                    random_touch_u2(zbj, tag="进广告直播间")
                    ad_live_entered = True
                    watch_live({"from": current_gold_task})
            else:
                try:

                    # name_node = end.down(
                    #     className="com.lynx.tasm.behavior.ui.text.FlattenUIText"
                    # )
                    name_node = d.xpath(
                        "(//com.lynx.tasm.behavior.ui.text.FlattenUIText)[3]"
                    )
                    if name_node.exists:
                        my_print(f"这轮广告名为:{name_node.get_text()}")
                        cycle_ad_name.append(name_node.get_text())
                except ValueError as e:
                    my_print(f"解析广告名出错:{e}")
            random_touch_u2(end, tag="领广告奖励")
            sleep(3)
        else:
            wait_ad_end(True)
    except ValueError as e:
        raise my_print("识别控件出错。{}")


def check_new_ad(options={}):
    my_print(f"等广告结束,options:{options}")
    global ad_time
    global current_gold_task

    from_ad = options.get("from", "")

    wait_ad_end(False, {**options})
    check_ad_result({**options})
    if from_ad == "ad":
        ad_time = int(time.time())


def check_ad_result(options={}, count=0):
    global cycle_low_coin
    global cycle_ad_name
    global cycle_ad_coin
    global current_gold_task
    global cycle_total_coin
    ad_count = options.get("ad_count", 1)
    my_print(f"看的第{ad_count}轮广告,options:{options}")
    result = ocr_screen()
    my_print(f"check_ad_result:{result}")
    lq = next(
        (
            item
            for item in result
            if isinstance(item, dict) and item.get("text") == "领取奖励"
        ),
        None,
    )
    ad_end = next(
        (
            item
            for item in result
            if isinstance(item, dict)
            and (item.get("text") == "开心收下" or item.get("text") == "评价并收下金币")
        ),
        None,
    )

    secrect_end = next(
        (
            item
            for item in result
            if isinstance(item, dict) and item.get("text") == "我知道了"
        ),
        None,
    )
    if lq:
        pos = lq["text_box_position"][0]
        random_touch((pos[0], pos[1]), (0, 200), (0, 60), tag="继续看广告")

        # coin_count = d(
        #     textMatches=number_pattern,
        #     descriptionMatches=number_pattern,
        #     className="com.lynx.tasm.behavior.ui.text.FlattenUIText",
        # )
        # try:
        #     if coin_count.exists:
        #         my_print(f"coin_countInfo:{coin_count.info}")
        #         cycle_ad_coin.append(coin_count.get_text())
        #         my_print(f"单个广告获取到的金额为{coin_count.get_text()}")
        #         ws_report(
        #             {
        #                 "message": f"【{SOURCE_MAP.get(current_gold_task,'')}】,第{ad_count}个广,金币数：{coin_count.get_text()}",
        #             }
        #         )
        #     else:
        #         my_print(f"未获取到单个广告获取到的金额")
        # except ValueError as e:
        #     raise f"获取单次金币数量失败:{e}"

        sleep(3)
        check_new_ad({**options, "ad_count": ad_count + 1})
    elif secrect_end:
        pos = secrect_end["text_box_position"][0]
        random_touch((pos[0], pos[1]), (0, 200), (0, 60), tag="领神秘宝箱")
        sleep(3)
        check_ad_result({**options})
    elif ad_end:
        pos = ad_end["text_box_position"][0]
        gx = d(text="恭喜累计获得奖励")
        if gx.exists:
            my_print("恭喜累计获得奖励存在，查找数量")
            amount = gx.sibling(
                textMatches=number_pattern,
                className="com.lynx.tasm.behavior.ui.text.FlattenUIText",
            )
            if amount.exists:
                print(f"获取到的金额为{amount.get_text()}")
                c = int(amount.get_text())
                rc = config.get("basic.coin.low", 400)
                avg = c // ad_count
                cycle_total_coin = c
                my_print(
                    f"【{SOURCE_MAP.get(options.get('from', ''))}】看完一轮广告,共{ad_count}个,收益为:{c},平均值为:{avg},一轮广告名为:{cycle_ad_name},金币数为：{cycle_ad_coin}"
                )
                ws_report(
                    {
                        "message": f"【{SOURCE_MAP.get(options.get('from', ''))}】看完一轮广告,共{ad_count}个,收益为:{c},平均值为:{avg},一轮广告名为:{cycle_ad_name},金币数为：{cycle_ad_coin}",
                        "content": {
                            "ad_names": cycle_ad_name,
                        },
                    }
                )

                sleep(2)
                if current_gold_task == "box" or current_gold_task == "ad":
                    if avg < rc:
                        cycle_low_coin = True
                    else:
                        cycle_low_coin = False

        random_touch((pos[0], pos[1]), (0, 200), (0, 60), tag="广告一轮结束")
        sleep(4)
    else:
        if count > 1:
            my_print("3次未检测到结果，暂停查找")
            return
        my_print("未检测到结果，继续检测")
        sleep(3)
        check_ad_result({**options, "ad_count": ad_count + 1}, count + 1)


def start_script():

    global cycle_low_coin
    reset_active = config.get("basic.active.reset.flag", True)
    if reset_active:
        save_data_with_obj(
            {
                "watched_recommend_count": 0,
                "recommend_executed": False,
                "search_execute_count": 0,
                "search_executed": False,
                "searched_count": 0,
                "hot_executed": False,
                "watched_hot_count": 0,
            }
        )

    check_task_alert()
    tasks = config.get("tasks", [])
    if len(tasks) == 0:
        tasks = ["active"]

    # 先检测是否要做拉起的活跃
    start_reopen_active()

    while True:
        my_print("脚本执行中")
        for task in tasks:
            my_print(f"task is {task}")
            if task == "active":
                start_recommend()
            elif task == "search":
                start_search()
            elif task == "hot":
                start_hot()
            elif task == "box":
                start_box()
            elif task == "pig":
                start_pig()
            elif task == "ad":
                start_ad()
            else:
                """其他任务暂不执行"""
                pass

        """没有金币任务回去重做活跃"""
        if "box" not in tasks and "pig" not in tasks and "ad" not in tasks:
            # or cycle_low_coin
            # if cycle_low_coin:
            #     ws_report(
            #         {
            #             "message": f"一轮任务金币低于预期{config.get('basic.coin.low',400)},大活跃重新执行,请及时进行干预处理"
            #         }
            #     )
            #     my_print("一轮任务金币低于预期，重新做活跃")
            # else:
            my_print("没配置金币任务，返回做活跃")
            save_data_with_obj(
                {
                    "watched_recommend_count": 0,
                    "recommend_executed": False,
                    "search_execute_count": 0,
                    "search_executed": False,
                    "searched_count": 0,
                    "hot_executed": False,
                    "watched_hot_count": 0,
                }
            )
            unset_operation("recommend_executed")
        else:
            # 记录做了金币任务了，用于重新拉起脚本时的几分钟活跃
            record_operation("task_ad_did")
            box_do_count = read_data("total.box.task.count", 0, SUMMARY_FILE)
            box_max_count = config.get("cycle.box.max", 5)
            my_print(f"【宝箱】任务执行次数：{box_do_count}，最大次数：{box_max_count}")

            ad_do_count = read_data("total.ad.task.count", 0, SUMMARY_FILE)
            ad_max_count = config.get("cycle.ad.max", 5)
            my_print(f"【AD】任务执行次数：{ad_do_count}，最大次数：{ad_max_count}")

            pig_do_count = read_data("total.pig.play.count", 0, SUMMARY_FILE)
            pig_max_count = config.get("cycle.pig.max", 5)
            my_print(f"【粉猪】任务执行次数：{pig_do_count}，最大次数：{pig_max_count}")

            if (
                box_do_count >= box_max_count
                and ad_do_count >= ad_max_count
                and pig_do_count >= pig_max_count
            ):
                # TODO:上报停止
                ws_report(
                    {},
                    real_data={
                        "type": "request",
                        "deviceId": d.serial,
                        "userToken": token,
                        "scriptName": SCRIPT_NAME,
                        "serial": str(int(time.time()) * 1000),
                        "desc": f"{d.serial}-{today}-主动停止调度脚本",
                        "content": {
                            "requestType": "stop_schedule",
                            "stop_until": f"{today} 23:59:59",
                            "always_disable": False,
                            "comment": "",
                        },
                    },
                )
                end_script({"reason": "任务执行次数已达到最大"})
                return
            start_interval_task()


def get_task_config():
    """获取设备脚本配置项"""
    global config
    headers = {"Content-Type": "application/json"}
    params = {"script": SCRIPT_NAME}

    try:
        response = requests.get(
            f"{remote_host}/script-client/{d.serial}/tasks",
            params=params,
            headers=headers,
            timeout=10,
        )
        response.raise_for_status()  # 自动处理HTTP错误码
        result = response.json()
        if result.get("code") == 200:
            config = {}
            tasks = result.get("data")
            task_names = []
            for task in tasks:
                task_name = task.get("name").lower()
                task_names.append(task_name)
                config[task_name] = task
            config["tasks"] = task_names
            log(f"获取到的远程配置为:{config}")
        else:
            log("未获取到配置，使用默认配置")

        log(f"config:{config.get('basic.cycle.time')}")
    except requests.exceptions.RequestException as e:
        log(f"请求脚本服务相关配置失败:{e}")


# def get_dev_config():
#     """获取设备脚本配置项"""
#     global config
#     headers = {"Content-Type": "application/json"}
#     params = {"deviceId": d.serial, "scriptName": SCRIPT_NAME}

#     try:
#         response = session.get(
#             f"http://{host}" + "/get_script_props",
#             params=params,
#             headers=headers,
#             timeout=10,
#         )
#         response.raise_for_status()  # 自动处理HTTP错误码
#         results = response.json()

#         data = results.get("data", {})
#         scripts = data.get("scripts", [])
#         if len(scripts) > 0:
#             config = scripts[0].get("settings", {})
#             my_print(f"获取到的远程配置为:{config}")
#         else:
#             my_print("未获取到配置，使用默认配置")

#         # config["dev.tags"] = ",".join(
#         #     item["match"] for item in config.get("active.key.search.tags", [])
#         # )
#         my_print(f"config:{config}")
#     except requests.exceptions.RequestException as e:
#         my_print(f"请求脚本服务相关配置失败:{e}")


def end_script(param={}):
    global start_time
    global cycle_summary

    cycle_summary["end.time"] = time_format()
    cycle_summary["run.time"] = int(time.time()) - start_time
    reason = param.get("reason", "")
    my_print(f"退出脚本脚本执行：{reason}")
    type = param.get("type", "")
    save_data_with_key(
        "total.script.play.seconds",
        int(time.time()) - start_time,
        SUMMARY_FILE,
        {"cumulation": True},
    )
    sleep(1)
    ws_report(
        {
            "message": f"""
            结束脚本，原因：{reason}，
            本次运行汇总：开始时间：{cycle_summary.get('start.time')}，
            结束时间：{cycle_summary.get('end.time')}，
            总计时长：{convert_seconds(cycle_summary.get('run.time'))}，
            总计点赞：{cycle_summary.get('like.count', 0)}次，
            总计评论：{cycle_summary.get('comment.count', 0)}次，
            总计送礼物：{cycle_summary.get('gift.count', 0)}次，
            总计关注：{cycle_summary.get('focus.count', 0)}次，
            总计收藏：{cycle_summary.get('collect.count', 0)}次，
            总计推荐：{cycle_summary.get('recommend.count', 0)}次，
            总计看视频：{cycle_summary.get('video.play.count', 0)}个，
            看直播间：{cycle_summary.get('live.play.count', 0)}个，
            执行宝箱任务：{cycle_summary.get('box.task.count', 0)}次，
            执行ad广：{cycle_summary.get('ad.task.count', 0)}次，
            养猪执行：{cycle_summary.get('pig.task.count', 0)}次，
            签到情况：{"已签到" if check_operation("signed") else "未签到"}，
            预约情况：{"已预约" if check_operation("pre_ordered") else "未预约"}
            """,
            "content": type,
        }
    )

    report_summary()

    kill_app()
    home()
    stop_app(PKG)
    # TODO:结束脚本上报统计信息
    if type == "stop":
        ws_report(
            {},
            real_data={
                "type": "action",
                "serial": str(int(time.time()) * 1000),
                "msg": "已停止脚本",
                "ret": 0,
            },
        )
    exit_event.set()


def on_message(ws, message):
    my_print(f"on_message:{message}")
    try:
        data = json.loads(message)
    except ValueError as e:
        my_print(f"解析消息体出错，不是标准的json格式")

        data = {}
    if data.get("action") == "stop":
        # TODO:停止脚本逻辑
        my_print("收到停止指令，准备停止")
        end_script({"reason": "收到停止指令", "type": "stop"})


def on_error(ws, error):
    my_print(f"on_error:{error}")


def on_close(ws):
    my_print(f"on_close:")


def on_open(ws):
    my_print(f"on_open:{ws}")
    ws_report(
        {}, real_data={"accountNo": d.serial, "userToken": token, "type": "authorize"}
    )


def ws_report(data, reportType="message", real_data=None):
    """
    发送websocket消息
    """
    if real_data:
        body = real_data
    else:
        content = json.dumps(data, ensure_ascii=False)
        my_print(f"通过websocket上报数据：{content}")
        body = {
            "deviceId": d.serial,
            "scriptName": SCRIPT_NAME,
            "serial": str(int(time.time()) * 1000),
            "reportType": reportType,
            "content": data,
            "type": "report",
        }
    try:
        ws.send(json.dumps(body, ensure_ascii=False))
    except websocket.WebSocketTimeoutException:
        my_print("连接或操作超时")
    except websocket.WebSocketConnectionClosedException:
        my_print("连接已关闭")
    except ConnectionRefusedError:
        my_print("无法连接服务器")
    except Exception as e:
        my_print(f"未知错误: {e}")


def connect_socket():
    global ws
    # websocket.enableTrace(True)
    ws = websocket.WebSocketApp(
        url=f"ws://{host}/talk",
        on_message=on_message,
        on_close=on_close,
        on_open=on_open,
    )
    ws_daemon_thread = threading.Thread(target=ws.run_forever)
    ws_daemon_thread.daemon = True
    ws_daemon_thread.start()


def report_summary():
    summary = load_data(SUMMARY_FILE)
    date_entry = summary.setdefault(today, {})
    device_entry = date_entry.setdefault(d.serial, {})
    ws_report(
        {},
        real_data={
            "type": "statistic",
            "deviceId": d.serial,
            "userToken": token,
            "scriptName": SCRIPT_NAME,
            "serial": str(int(time.time()) * 1000),
            "statisticType": "statistic",
            "desc": f"{d.serial}-{today}-汇总数据",
            "content": device_entry,
        },
    )


def login():
    global token
    headers = {"Content-Type": "application/json"}
    payload = {"accountNo": d.serial, "password": "123456", "type": "authorize"}
    try:
        response = session.post(
            f"http://{host}" + "/login",
            json=payload,
            headers=headers,
            timeout=10,
        )
        response.raise_for_status()
        results = response.json()
        logger.info(f"results:{results}")
        token = results.get("userToken", "")
    except requests.exceptions.RequestException as e:
        my_print(f"登录请求出错:{str(e)}")


def is_app_home() -> bool:
    """
    判断是否在首页
    """
    return d(resourceId="com.ss.android.ugc.aweme.lite:id/root_view").exists

if __name__ == "__main__":
    # 解锁屏幕
    wake()
    # 登录
    # 连接websocket
    login()
    connect_socket()
    get_task_config()
    # 重启应用
    stop_app(PKG)
    sleep(2)
    start_app(PKG)
    signed = check_operation("signed")
    sleep(10 if signed else 20)

    # # report_summary()

    thread = threading.Thread(target=screen_checker)
    thread.daemon = True
    thread.start()

    start_time = int(time.time())

    mthread = threading.Thread(target=start_script)
    mthread.daemon = True
    mthread.start()

    cycle_summary["start.time"] = time_format()

    clear_before_log()
    my_print("主流程运行中...")
    ws_report({"message": "开始抖音脚本", "content": ""})
    save_data_with_key("total.script.play.count", 1, SUMMARY_FILE, {"cumulation": True})
    # 等待退出事件（让主线程挂住，直到后台触发）
    exit_event.wait()
    my_print("[主流程] 收到退出信号，脚本结束")
    # ws.close()
    sys.exit(0)
